package jp.que.ti.yhj.utils;

import java.util.LinkedList;
import java.util.List;


/**
 * 例外に関連するユーティリティー
 * 
 * @author Hajime.Yanagawa
 * @author $Author: yanagawa.hajime $ (last modified)
 * @version $Revision: $
 */
public class ExceptionUtils {
	private ExceptionUtils() {
	}

	/** 改行文字 */
	static final String LINE_SEPARATOR = StringUtils.LINE_SEPARATOR;

	/**
	 * 引数 th のスタックとレースを文字列に変換して返却する
	 * 
	 * @param th
	 *            Throwable または、例外
	 * @return スタックとレースを文字列
	 */
	public static String stackTraceString(Throwable th) {
		StringBuilder sb = new StringBuilder();
		sb.append(th + LINE_SEPARATOR);
		sb = stackTraceString2StringBuilder(th, sb);

		List<Throwable> causes = causes(th);
		for (Throwable cause : causes) {
			sb.append("Caused by: " + cause + LINE_SEPARATOR);
			sb = stackTraceString2StringBuilder(cause, sb);
		}

		return sb.toString();
	}

	private static List<Throwable> causes(Throwable th) {
		List<Throwable> rtn = new LinkedList<Throwable>();
		Throwable nowCause = null;
		nowCause = th.getCause();
		while (nowCause != null) {
			rtn.add(nowCause);
			nowCause = nowCause.getCause();
		}
		return rtn;
	}

	private static StringBuilder stackTraceString2StringBuilder(//
			Throwable throwable, StringBuilder warehouseBuf) {
		if (throwable == null) {
			return warehouseBuf;
		}
		StackTraceElement[] trace = throwable.getStackTrace();
		for (int i = 0; i < trace.length; i++) {
			warehouseBuf.append("\tat " + trace[i] + LINE_SEPARATOR);
		}
		return warehouseBuf;
	}
}
