/*
 * created  2008/07/25 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;

import jp.que.ti.yhj.less.than.more.test.LessThanMoreBaseTestCase;

/**
 * {@link BackwardByteReader} のテストクラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class BackwardByteReaderTest extends LessThanMoreBaseTestCase {
	private BackwardByteReader reader;

	/** {@link BackwardByteReader#read()}のテスト */
	public void test_read() {
		final File fl = new File("testdata/test4page.txt");
		reader = new BackwardByteReader(fl);
		assertEquals('P', (byte) reader.read());
		assertEquals('O', (byte) reader.read());
		assertEquals('N', (byte) reader.read());
		assertEquals('M', (byte) reader.read());
		assertEquals('L', (byte) reader.read());

		assertEquals('\n', (byte) reader.read());
		assertEquals('\r', (byte) reader.read());

		assertEquals('\n', (byte) reader.read());
		assertEquals('\r', (byte) reader.read());
		assertEquals('K', (byte) reader.read());
		assertEquals('J', (byte) reader.read());
		assertEquals('I', (byte) reader.read());
		assertEquals('H', (byte) reader.read());
		assertEquals('G', (byte) reader.read());
		assertEquals('F', (byte) reader.read());
		assertEquals('E', (byte) reader.read());
		assertEquals('D', (byte) reader.read());
		assertEquals('C', (byte) reader.read());
		assertEquals('B', (byte) reader.read());
		assertEquals('A', (byte) reader.read());

		assertEquals('\n', (byte) reader.read());
		assertEquals('z', (byte) reader.read());
		assertEquals('y', (byte) reader.read());
		assertEquals('x', (byte) reader.read());
		assertEquals('w', (byte) reader.read());
		assertEquals('v', (byte) reader.read());
		assertEquals('u', (byte) reader.read());
		assertEquals('t', (byte) reader.read());
		assertEquals('s', (byte) reader.read());
		assertEquals('r', (byte) reader.read());
		assertEquals('q', (byte) reader.read());
		assertEquals('p', (byte) reader.read());
		assertEquals('o', (byte) reader.read());
		assertEquals('n', (byte) reader.read());
		assertEquals('m', (byte) reader.read());
		assertEquals('l', (byte) reader.read());
		assertEquals('k', (byte) reader.read());

		assertEquals('\r', (byte) reader.read());
		assertEquals('j', (byte) reader.read());
		assertEquals('i', (byte) reader.read());
		assertEquals('h', (byte) reader.read());
		assertEquals('g', (byte) reader.read());
		assertEquals('f', (byte) reader.read());

		assertEquals('\n', (byte) reader.read());
		assertEquals('e', (byte) reader.read());
		assertEquals('d', (byte) reader.read());
		assertEquals('c', (byte) reader.read());
		assertEquals('b', (byte) reader.read());
		assertEquals('a', (byte) reader.read());
		assertEquals(-1, reader.read());
		assertEquals(-1, reader.getPosition());

		reader.setPosition(fl.length() - 1);
		assertEquals('P', (byte) reader.read());
		reader.setPosition(fl.length() - 1);
		assertEquals('P', (byte) reader.read());
	}

	/** {@link BackwardByteReader#readLine(long)}のテスト */
	public void test_readLine() {
		final File file = new File("testdata/test4page.txt");
		reader = new BackwardByteReader(file);

		byte[] rtn = null;
		long pos = file.length() - 1;
		rtn = reader.readLine(pos);
		assertEquals("LMNOP", new String(rtn));

		pos = pos - rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("\r\n", new String(rtn));

		pos = pos - rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("ABCDEFGHIJK\r\n", new String(rtn));

		pos = pos - rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("klmnopqrstuvwxyz\n", new String(rtn));

		pos = pos - rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("fghij\r", new String(rtn));

		pos = pos - rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("abcde\n", new String(rtn));

		pos = pos - rtn.length;
		try {
			rtn = reader.readLine(pos);
		} catch (FileEdgeException fe) {
			assertTrue(true);
		}
	}

	/** @see junit.framework.TestCase#tearDown() */
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		if (reader != null) {
			reader.close();
		}
	}

}
