package jp.que.ti.yhj.utils.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import jp.que.ti.yhj.testutil.TestUtils;
import jp.que.ti.yhj.utils.file.FileUtils;
import junit.framework.TestCase;

/** {@link FileUtils} のテストクラス */
public class FileUtilsTest extends TestCase {

	/** {@link FileUtils#relativePath(File, File)}のテスト */
	public void testRelativePath() {
		String file = null;
		String base = null;
		String rtn = null;
		File fromFile = null;
		File baseFile = null;

		// 通常ファイルの確認
		base = "testdata/data/from";
		file = "a/a.txt";
		fromFile = new File(base + "/" + file);
		baseFile = new File(base);

		rtn = FileUtils.relativePath(baseFile, fromFile);
		assertEquals(file, rtn);

		// ディレクトリの確認
		base = "testdata/data";
		file = "from/a";
		fromFile = new File(base + "/" + file + "/");
		baseFile = new File(base);

		rtn = FileUtils.relativePath(baseFile, fromFile);
		assertEquals(file, rtn);
	}

	/** {@link FileUtils#createFileOutputStream(File)}のテスト */
	public void testCreateFileOutputStream() {
		String path = "testdata/tmp/fostest/a.txt";

		TestUtils.del(path);

		FileOutputStream fos = null;
		try {
			fos = FileUtils.createFileOutputStream(new File(path));
			assertNotNull(fos);
		} finally {
			try {
				fos.close();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}

	/** {@link FileUtils#fileListWithDir(File)}のテストメソッド */
	public void testFileList() {
		String from = null;
		from = "testdata/data/from/a/a.txt";
		File fl = null;
		List<File> files = null;
		fl = new File(from);
		files = FileUtils.fileListWithDir(fl);
		assertEquals(1, files.size());

		from = "testdata/data/from";

		fl = new File(from);
		files = FileUtils.fileListWithDir(fl);

		files = TestUtils.removeSvn(files);// svn管理下のファイルは除外してテスト
		assertEquals(fl.getAbsolutePath() + " のファイルおよびディレクトリ一覧数を確認" //
		, 10, files.size());
	}

	/** {@link FileUtils#fileListWithNoDir(File)}のテストメソッド */
	public void testFileListWithNoDir() {
		String from = null;
		from = "testdata/data/from";
		File fl = null;
		List<File> files = null;

		fl = new File(from);
		files = FileUtils.fileListWithNoDir(fl);
		files = TestUtils.removeSvn(files);// svn管理下のファイルは除外してテスト
		assertEquals(fl.getAbsolutePath() + " のファイル一覧確認", 6, files.size());
	}
}
