/*
 * FontSettingPanel.java
 *
 * Created on 2008/09/12, 22:33
 */
package jp.que.ti.yhj.less.than.more.swview;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JComboBox;

/**
 *
 * @author  kaka
 */
public class FontSettingPanel extends javax.swing.JPanel {

    /** Creates new form FontSettingPanel */
    public FontSettingPanel() {
        initComponents();
        coustomInitComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        fontLbl = new javax.swing.JLabel();
        fontSizeCombo = new javax.swing.JComboBox();
        fontComboBox = new javax.swing.JComboBox();

        setMaximumSize(new java.awt.Dimension(300, 20));
        setMinimumSize(new java.awt.Dimension(200, 20));
        setPreferredSize(new java.awt.Dimension(240, 20));

        fontLbl.setFont(new java.awt.Font("Dialog", 0, 12));
        fontLbl.setText("Font");
        fontLbl.setMaximumSize(new java.awt.Dimension(30, 13));
        fontLbl.setMinimumSize(new java.awt.Dimension(25, 20));
        fontLbl.setPreferredSize(new java.awt.Dimension(27, 20));

        fontSizeCombo.setEditable(true);
        fontSizeCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "6", "8", "9", "10", "11", "12", "18", "24" }));
        fontSizeCombo.setMaximumSize(new java.awt.Dimension(100, 20));
        fontSizeCombo.setMinimumSize(new java.awt.Dimension(50, 20));
        fontSizeCombo.setPreferredSize(new java.awt.Dimension(50, 20));

        fontComboBox.setMaximumSize(new java.awt.Dimension(32767, 20));
        fontComboBox.setMinimumSize(new java.awt.Dimension(51, 20));
        fontComboBox.setPreferredSize(new java.awt.Dimension(56, 20));
        fontComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(fontLbl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fontComboBox, 0, 149, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fontSizeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 52, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(fontLbl, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(fontSizeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(fontComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void fontComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontComboBoxActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_fontComboBoxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox fontComboBox;
    private javax.swing.JLabel fontLbl;
    private javax.swing.JComboBox fontSizeCombo;
    // End of variables declaration//GEN-END:variables

    /** このコンポーネントの初期化(独自拡張) */
    private void coustomInitComponents() {
        getFontComboBox().addItem(Font.MONOSPACED);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (String font : fonts) {
            getFontComboBox().addItem(font);
        }
        final int max = fontSizeCombo.getItemCount();
        int selectedIdx = 0;
        for (int idx0 = 0; idx0 < max; idx0++) {
            final String item = fontSizeCombo.getItemAt(idx0) + "";
            if (item.trim().equals("12")) {
                selectedIdx = idx0;
            }
        }
        fontSizeCombo.setSelectedIndex(selectedIdx);
    }

    /**
     * フォントサイズを設定するためのコンボボックスの getter
     * @return フォントサイズを設定するためのコンボボックス
     */
    public JComboBox getFontSizeCombo() {
        return fontSizeCombo;
    }

    /**
     * フォント名を指定するためのコンボボックスの getter
     * @return フォント名を指定するためのコンボボックス
     */
    public JComboBox getFontComboBox() {
        return fontComboBox;
    }
}
