package jp.que.ti.yhj.utils.file;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

import jp.que.ti.yhj.utils.ConsoleUtils;
import jp.que.ti.yhj.utils.StringUtils;

/**
 * jar ファイルについてのユーティリティーライブラリ
 * 
 * @author yan.j
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class JarUtils {

	/**
	 * MANIFEST ファイルの Signature-Version の情報を返却しするメインメソッド
	 * 
	 * @param args
	 *            第1引数:jarファイルのパス
	 */
	public static void main(String[] args) {
		String fileName = null;
		if (args == null || args.length == 0) {
			fileName = ConsoleUtils.in("jarファイルパス");
		} else {
			fileName = StringUtils.yen2Slash(args[0]);
		}
		if (StringUtils.isEmpty(fileName)) {
			System.out.println("jarファイルパスが入力されていません");
			System.exit(1);
		} else {
			System.out.println("VERSION : " + jarVersion(new File(fileName)));
		}
	}

	private JarUtils() {
	}

	/**
	 * jarファイルのバージョンを返却します。MANIFEST ファイルの Signature-Version の情報を返却します。
	 * 
	 * @param jarFile
	 *            jar ファイル
	 * @return バージョンをあらわす文字列
	 */
	public static String jarVersion(File jarFile) {
		return jarManifestMainAttributesValue(jarFile,
				Attributes.Name.SIGNATURE_VERSION);
	}

	/**
	 * jarファイルのMANIFEST ファイルの 情報を返却します。
	 * 
	 * @param jarFile
	 *            jar ファイル
	 * @param name
	 *            マニフェストの属性を示す文字列
	 * @return バージョンをあらわす文字列
	 */
	public static String jarManifestMainAttributesValue(File jarFile,
			Attributes.Name name) {
		if (jarFile == null) {
			throw new IllegalStateException("引数がnullです");
		}
		JarFile jar = null;
		try {
			jar = new JarFile(jarFile);
		} catch (IOException e) {
			throw new RuntimeException("jarファイル読み込み失敗 jarFilePath="
					+ jarFile.getAbsolutePath(), e);
		}
		String rtn;
		try {
			rtn = jar.getManifest().getMainAttributes().getValue(name);
		} catch (IOException e) {
			throw new RuntimeException("jarファイル読み込み失敗 jarFilePath="
					+ jarFile.getAbsolutePath(), e);
		}
		return rtn;

	}
}
