/*
 * created  2009/05/06 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionEvent;
import java.util.logging.Level;

/**
 * 次ページ表示のためのアクションリスナー
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class NextPageActionListener extends LessThanMoreBaseActionListener {
	@Override
	public void actionPerformed(ActionEvent event) {
		if (getController().getViewer().getFile() == null) {
			return;
		}

		try {
			final int rSize = getController().readingSize();
			getController().getViewer().setReadingLength(rSize);
			getController().getFrame().setReadingLengthString("" + rSize);
			getController().viewNextPage();
			getController().update();
			getController().clearStatusMessage();
		} catch (RuntimeException e) {
			log.log(Level.INFO, e.getMessage(), e);
			getController().setStatusMessage(e);
		}
	}
}
