/*
 * created  2008/06/17 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

import jp.que.ti.yhj.less.than.more.command.IllegalPositionException;
import jp.que.ti.yhj.less.than.more.command.SearchBackwardCMD;
import jp.que.ti.yhj.less.than.more.command.SearchBaseCMD;
import jp.que.ti.yhj.less.than.more.command.SearchForwardCMD;
import jp.que.ti.yhj.utils.ConsoleUtils;
import jp.que.ti.yhj.utils.StringUtils;
import jp.que.ti.yhj.utils.log.LogUtils;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class LessThanMoreCUIController extends LessThanMoreController {

	final static Options LINE_OPTIONS;

	final static Options VIEW_LOOP_HELP_COMMAND;

	static {
		Option help = new Option("h", "help", false, "print this message");
		Option encoding = new Option("e", "encoding", true,
				"input file encoding. ex)SJIS,UTF-8,EUC_JP ...");
		encoding.setArgName("charsetName");
		LINE_OPTIONS = new Options();
		LINE_OPTIONS.addOption(help);
		LINE_OPTIONS.addOption(encoding);
	}

	static {
		Option help = new Option("h", false, "print this message");
		Option enter = new Option("EnterKey", false, "view next page");
		Option forward = new Option("f", false, "view next page");
		Option backward = new Option("b", false, "view privious page");
		Option plus = new Option("plus", true,
				"move n byte forward and view page");
		plus.setArgName("byte");
		Option minus = new Option("minus", true,
				"move n byte backward and view page");
		minus.setArgName("byte");
		Option searchForward = new Option("slush", true, "search forward");
		searchForward.setArgName("search ward");
		Option searchBackward = new Option("question", true, "search backward");
		searchBackward.setArgName("search ward");
		Option quit = new Option("q", false, "quit this aplication");

		VIEW_LOOP_HELP_COMMAND = new Options();
		VIEW_LOOP_HELP_COMMAND.addOption(help);
		VIEW_LOOP_HELP_COMMAND.addOption(enter);
		VIEW_LOOP_HELP_COMMAND.addOption(forward);
		VIEW_LOOP_HELP_COMMAND.addOption(backward);
		VIEW_LOOP_HELP_COMMAND.addOption(plus);
		VIEW_LOOP_HELP_COMMAND.addOption(minus);
		VIEW_LOOP_HELP_COMMAND.addOption(searchForward);
		VIEW_LOOP_HELP_COMMAND.addOption(searchBackward);
		VIEW_LOOP_HELP_COMMAND.addOption(quit);
	}

	/**
	 * メインメソッド
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		LogUtils.initLoggerConfig();
		LessThanMoreCUIController controller = new LessThanMoreCUIController();
		try {
			controller.lineParser(args);
		} catch (CannotContinueException e) {
			System.exit(0);
		}

		controller.getViewCommand().execute();
		System.out.println(controller.getViewer().getLastViewCache());

		boolean notEnd = true;
		while (notEnd) {
			try {
				System.out
						.println("   *** now position="
								+ controller.getViewer().getPosition()
								+ "input command! input \"h\" then displaying a help ***");
				final String command = ConsoleUtils.in("コマンド");
				controller.viewLoop(command.trim());
			} catch (IllegalPositionException e) {
				System.out.println(controller.getViewer().getLastViewCache());
				System.out.println(e.getLocalizedMessage());
			} catch (IllegalArgumentException e) {
				System.out.println(e.getLocalizedMessage());
			}
		}
	}

	/** 現在検索しているコマンド "/Fs or "/" or 空文字 */
	private String nowSearchingKey = "";

	/**
	 * メインメソッドから引き継いだ引数をハンドリングするためのメソッド
	 * 
	 * @param args
	 *            コマンドライン引数
	 */
	public void lineParser(String[] args) throws CannotContinueException {
		Options options = LINE_OPTIONS;
		CommandLineParser parser = new PosixParser();

		// parse the command line arguments
		CommandLine line = null;
		try {
			line = parser.parse(options, args);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}

		if (line.hasOption("h")) {
			final String message = "help option selected";
			printUsageString(options);
			throw new CannotContinueException(message);
		}

		if (line.hasOption("e")) {
			String optArg = line.getOptionValue("e");
			getViewer().setEncoding(optArg);
		}

		String[] inputedArgs = line.getArgs();
		if (inputedArgs == null || inputedArgs.length == 0) {
			final String message = "arguments missing !!";
			System.out.println(message);
			System.out.println();
			printUsageString(options);
			throw new CannotContinueException(message);
		} else if (inputedArgs.length == 1) {

			File inputFile = new File(StringUtils.yen2Slash(inputedArgs[0]));
			if (inputFile.exists()) {
				if (inputFile.isFile()) {
					getViewer().setFile(inputFile);
				} else {
					final String message = "INPUT FILE is not file!!";
					System.out.println(message);
					System.out.println();
					printUsageString(options);
					throw new CannotContinueException(message);
				}
			} else {
				final String message = "INPUT FILE is none !!";
				System.out.println(message);
				System.out.println();
				printUsageString(options);
				throw new CannotContinueException(message);
			}
		} else {
			final String message = "arguments too many !!";
			System.out.println(message);
			System.out.println();
			printUsageString(options);
			throw new CannotContinueException(message);
		}
	}

	private void printUsageString(Options options) {
		System.out.println(usageString(options));
	}

	final String usageString(Options options) {
		final String usage = "lessThanMore [OPTION]... [INPUT FILE]\n";
		final String header = " [OPTIONs]:";
		final String footer = "";

		return usageString(options, usage, header, footer);
	}

	private String usageString(Options options, String usage, String header,
			String footer) {
		HelpFormatter formatter = new HelpFormatter();
		StringWriter sw = new StringWriter();
		formatter.printHelp(
				new PrintWriter(sw)//
				, HelpFormatter.DEFAULT_WIDTH, usage, header, options,
				HelpFormatter.DEFAULT_LEFT_PAD, HelpFormatter.DEFAULT_DESC_PAD,
				footer, false);
		return sw.toString();
	}

	private void viewLoop(String command) {
		if (StringUtils.isEmpty(command)//
				|| "f".equals(command)) { // 次ページコマンド
			final String str = viewNextPage();
			System.out.println(str);

		} else if ("b".equals(command)) { // 前ページコマンド
			final String str = viewPreviousPage();
			System.out.println(str);

		} else if ("h".equals(command)) { // HELP
			viewLoopUsageString();
			System.out.println(viewLoopUsageString());

		} else if (command.indexOf("-") == 0 //
				|| command.indexOf("+") == 0) { // n byte 前後へ移動
			int tempInt = 0;
			String numStr = null;
			if (command.indexOf("+") == 0) {
				numStr = command.substring(1);
			} else {
				numStr = command;
			}
			try {
				tempInt = Integer.parseInt(numStr);
			} catch (RuntimeException e) {
				throw new IllegalArgumentException("Input is not number !! ", e);
			}
			getPosition().setSkipBytes(tempInt);
			getPosition().execute();
			getViewCommand().execute();
			System.out.println(getViewer().getLastViewCache());

		} else if ("q".equals(command)//
				|| "exit".equals(command)//
				|| "quit".equals(command)//
		) { // 終了コマンド
			System.exit(0);

		} else if (command.indexOf("/") == 0 // 後方検索コマンド
				|| command.indexOf("?") == 0 // 前方検索コマンド
				|| "n".equals(command) // 後方検索コマンド(継続)
				|| "N".equals(command) // 前方検索コマンド(継続)
		) {
			SearchBaseCMD searchCommand = null;
			if (command.indexOf("/") == 0 // 後方検索コマンド
					|| command.indexOf("?") == 0 // 前方検索コマンド
			) {
				this.nowSearchingKey = command.substring(0, 1);
				setSearchWord(command.substring(1));
				if (command.indexOf("/") == 0//
				) {
					searchCommand = new SearchForwardCMD(getViewer(),
							getSearchWord());
				} else {
					searchCommand = new SearchBackwardCMD(getViewer(),
							getSearchWord());
				}
			} else {
				if (StringUtils.isEmpty(this.nowSearchingKey)) {
					throw new IllegalArgumentException("no search word !! ");
				}
				if ("/".equals(this.nowSearchingKey)) { // 前方検索コマンド
					if ("n".equals(command)) { // 前方検索
						searchCommand = new SearchForwardCMD(getViewer(),
								getSearchWord());
					} else if ("N".equals(command)) { // 後方検索
						searchCommand = new SearchBackwardCMD(getViewer(),
								getSearchWord());
					} else {
						throw new RuntimeException(
								"unexpected command !! command=" + command);
					}
				} else if ("?".equals(this.nowSearchingKey)) { // 後方検索コマンド
					if ("n".equals(command)) { // 後方検索
						searchCommand = new SearchBackwardCMD(getViewer(),
								getSearchWord());
					} else if ("N".equals(command)) { // 前方検索
						searchCommand = new SearchForwardCMD(getViewer(),
								getSearchWord());
					} else {
						throw new RuntimeException(
								"unexpected command !! command=" + command);
					}
				} else {
					throw new RuntimeException(
							"unexpected nowSearchingKey !! nowSearchingKey="
									+ this.nowSearchingKey);
				}
			}
			searchCommand.execute();
			System.out.println(getViewer().getLastViewCache());
		}
	}

	final String viewLoopUsageString() {
		String rtn = usageString(VIEW_LOOP_HELP_COMMAND, "command[argument]",
				"", "");
		rtn = rtn.replace("-", "");
		rtn = rtn.replace("question", "?");
		rtn = rtn.replace("q", "q");
		rtn = rtn.replace("slush", "/");
		rtn = rtn.replace("minus", "-");
		rtn = rtn.replace("plus", "+");
		return rtn;
	}
}
