/*
 * created  2008/06/24 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.io.File;

import jp.que.ti.yhj.less.than.more.CannotContinueException;
import jp.que.ti.yhj.less.than.more.LessThanMoreCUIController;
import junit.framework.TestCase;

/**
 * {@link LessThanMoreCUIController} を使用して、{@link PositionCMD} をテストする。
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class PositionCMDTest extends TestCase {
	public void test_execute() throws CannotContinueException {
		LessThanMoreCUIController cntl = new LessThanMoreCUIController();
		cntl.lineParser(new String[] { "-e", "EUC-JP",
				"testdata/test-euc-jp.txt" });
		String rtn = null;

		PositionCMD pCmd = (PositionCMD) new PositionCMD(4).setTextViewer(cntl
				.getViewer());
		pCmd.execute();
		assertEquals(4, cntl.getViewer().getPosition());

		Command cmd = new ViewCMD().setTextViewer(cntl.getViewer());
		cmd.execute();
		rtn = cntl.getViewer().getLastViewCache();
		assertTrue("読み込み文字列確認 rtn=" + rtn//
		, rtn.indexOf("宇衣於1234567890-^") == 0);

		pCmd.setSkipBytes(-2);
		pCmd.execute();
		cmd.execute();
		assertEquals(2, cntl.getViewer().getPosition());
		rtn = cntl.getViewer().getLastViewCache();
		assertTrue("読み込み文字列確認 rtn=" + rtn//
		, rtn.indexOf("以宇衣於1234567890-^") == 0);
	}

	public void test_execute_ExceptionCase() throws CannotContinueException {
		LessThanMoreCUIController cntl = new LessThanMoreCUIController();
		String fileName = "testdata/test-euc-jp.txt";

		cntl.lineParser(new String[] { "-e", "EUC-JP", fileName });

		PositionCMD pCmd = (PositionCMD) new PositionCMD(new File(fileName)
				.getTotalSpace() - 1) //
				.setTextViewer(cntl.getViewer());

		// 例外が発生しない限界値
		cntl.getViewer().setPosition(0);
		pCmd.setSkipBytes(new File(fileName).length() - 1);
		try {
			pCmd.execute();
			assertTrue("例外が発生しない境界", true);
		} catch (IllegalPositionException e) {
			fail();
		}

		// 例外が発生する限界値
		pCmd.setSkipBytes(new File(fileName).length());
		try {
			pCmd.execute();
			fail();
		} catch (IllegalPositionException e) {
			assertTrue(true);
		}

		// 位置がマイナス
		cntl.getViewer().setPosition(0);
		pCmd.setSkipBytes(-1);
		pCmd.execute();
		assertEquals(0, cntl.getViewer().getPosition());
	}
}
