/*
 * created  2008/07/26 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;

/**
 * 順方向または逆方向にファイル読み込みを実現するためのインターフェイス定義です
 * 
 * @author yhj
 * @version $Revision$
 */
public interface ByteReader extends Closeable {
	/** 長さ0の byte 配列です */
	public static final byte[] BYTES_NODATA = new byte[0];

	/** リソースをクローズします */
	public void close() throws IOException;

	/** このリーダーがアクセスするファイルを取得します */
	public File getFile();

	/**
	 * このメソッドは現在の位置から1byte読み込み、読み込み位置を移動します。<br>
	 * 値のバイトは、0 〜 255 の範囲の int として返されます。ストリームの終わりに達したために読み込むバイトがない場合は、値 -1
	 * が返されます。 入力データが読み込めるようになるか、ファイルの終わりが検出されるか、または例外が発生するまで、このメソッドはブロックされます。<br>
	 * 
	 * @return データの次のバイト。ストリームの終わりに達した場合は -1
	 */
	public int read();

	/**
	 * 改行文字と引数 position の間のbyte 配列を返却します。
	 * サブクラスが順方向に読み込むクラスか逆方向に読むかによって、読み込む具体的な方法は異なります。
	 * 詳細はサブクラスのjavadocを参照してください。
	 * 
	 * @param position
	 *            読み込みの境界となるファイル位置
	 * @return 改行文字と引数 position の間のbyte 配列
	 */
	public byte[] readLine(long position);

	/**
	 * 読み込む方向が前方方向か、後方方向かを取得します。
	 * 
	 * @return 前方方向の場合、true。そうでない場合、false
	 */
	public boolean isForward();

	/**
	 * 次回呼び出される {@link #read()} により取得するアドレスを取得します。
	 * 
	 * @return 次回呼び出される {@link #read()} により取得するアドレス
	 */
	public long getPosition();

	/**
	 * 次回呼び出される {@link #read()} により取得するアドレスを設定します。
	 * 
	 * @param position
	 *            次回呼び出される {@link #read()} により取得するアドレス
	 */
	public void setPosition(long position);

}
