package jp.que.ti.yhj.utils;

import jp.que.ti.yhj.utils.ExceptionUtils;
import junit.framework.TestCase;

/** {@link ExceptionUtils}のテストクラス */
public class ExceptionUtilsTest extends TestCase {

	@Override
	protected void setUp() throws Exception {
		super.setUp();
	}

	/** {@link ExceptionUtils#stackTraceString(Throwable)}のテスト */
	public void testStackTraceString() {
		RuntimeException e1 = new RuntimeException("一番内側");
		IllegalArgumentException e2 = new IllegalArgumentException("真ん中", e1);
		Exception e3 = new IllegalArgumentException("一番外側", e2);

		// このメソッドでは、スタックトレースと似た文字列を生成したい。
		// e3.printStackTrace();
		String result = ExceptionUtils.stackTraceString(e3);

		final String thisMethodAtLine = //
		"at " + this.getClass().getName() + ".testStackTraceString"//
				+ "(" + this.getClass().getSimpleName()//
				+ ".java:";

		assertTrue("失敗時のログ result=" + result, result.indexOf(//
				"java.lang.IllegalArgumentException: 一番外側"
						+ ExceptionUtils.LINE_SEPARATOR //
						+ "\t" + thisMethodAtLine// 
				) == 0);

		assertTrue("失敗時のログ result=" + result, result.indexOf(//
				ExceptionUtils.LINE_SEPARATOR
						+ "Caused by: java.lang.IllegalArgumentException: 真ん中"
						+ ExceptionUtils.LINE_SEPARATOR //
						+ "\t" + thisMethodAtLine// 
				) > 0);

		assertTrue("失敗時のログ result=" + result, result.indexOf(//
				ExceptionUtils.LINE_SEPARATOR
						+ "Caused by: java.lang.RuntimeException: 一番内側"
						+ ExceptionUtils.LINE_SEPARATOR //
						+ "\t" + thisMethodAtLine// 
				) > 0);
	}
}
