/*
 * created  2008/08/07 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;

import junit.framework.TestCase;

/**
 * {@link ForwardByteReader} のテストクラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class ForwardByteReaderTest extends TestCase {
	private ForwardByteReader reader;

	/** {@link ForwardByteReader#readLine(long)}のテスト */
	public void test_readLine() {
		final File file = new File("testdata/test4page.txt");
		reader = new ForwardByteReader(file);

		byte[] rtn = null;
		long pos = 0;
		rtn = reader.readLine(pos);
		assertEquals("abcde\n", new String(rtn));

		pos = pos + rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("fghij\r", new String(rtn));

		pos = pos + rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("klmnopqrstuvwxyz\n", new String(rtn));

		pos = pos + rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("ABCDEFGHIJK\r\n", new String(rtn));

		pos = pos + rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("\r\n", new String(rtn));

		pos = pos + rtn.length;
		rtn = reader.readLine(pos);
		assertEquals("LMNOP", new String(rtn));
	}

	/** @see junit.framework.TestCase#tearDown() */
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		if (reader != null) {
			reader.close();
		}
	}

}
