/*
 * created  2008/06/14 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more;

import java.io.File;
import java.io.UnsupportedEncodingException;

import jp.que.ti.yhj.less.than.more.test.LessThanMoreBaseTestCase;

/**
 * {@link TextViewer} のテストクラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class TextViewerTest extends LessThanMoreBaseTestCase {
	private static final String YEN_REGEX = "\\";

	public void test_view_sjis() {
		TextViewer viewer = new TextViewer();
		viewer.setFile(new File("testdata/test-sjis.txt"));
		viewer.setEncoding(TextViewer.SHIFT_JIS);

		String str = viewer.view();
		test_viewCommonAllText(str);

		// 改行まで読み込んだかのテスト
		viewer.setPosition(0);
		viewer.setReadingLength(4);

		str = viewer.view();
		viewer.setPosition(viewer.getEndPosition());

		str = viewer.view();
		assertEquals("改行から改行までが読み込めるまで"//
				, "あいうえお\r\n", str);

	}

	public void test_view_euc() {
		TextViewer viewer = new TextViewer();
		viewer.setFile(new File("testdata/test-euc-jp.txt"));
		viewer.setEncoding(TextViewer.EUC_JP);

		String str = viewer.view();
		test_viewCommonAllText(str);

		// 改行まで読み込んだかのテスト
		viewer.setPosition(0);
		viewer.setReadingLength(4);

		str = viewer.view();
		viewer.setPosition(viewer.getEndPosition());
		str = viewer.view();
		assertEquals("改行から改行までが読み込めるまで"//
				, "あいうえお\r\n", str);

	}

	public void test_view_utf_8() {
		TextViewer viewer = new TextViewer();
		viewer.setFile(new File("testdata/test-utf-8.txt"));
		viewer.setEncoding(TextViewer.UTF_8);

		String str = viewer.view();
		test_viewCommonAllText(str);

		// 改行まで読み込んだかのテスト
		viewer.setPosition(0);
		viewer.setReadingLength(4);

		str = viewer.view();
		viewer.setPosition(viewer.getEndPosition());
		str = viewer.view();
		assertEquals("改行から改行までが読み込めるまで"//
				, "あいうえお\r\n", str);
	}

	public void test_view_sjis_0_len10() {
		TextViewer viewer = new TextViewer();
		String str = null;
		viewer.setFile(new File("testdata/test-sjis.txt"));
		viewer.setEncoding(TextViewer.SHIFT_JIS);
		viewer.setPosition(0);
		viewer.setReadingLength(10);

		str = viewer.view();
		assertEquals(
				"改行が見つかるまで読み込むはず",
				"安以宇衣於1234567890-^\\!\"#$%&'()=〜|@｢;:｣､｡･\\`{+*}<>?_１２３４５６７８９０−＾￥！”＃＄％＆’（）＝〜｜@｢；：」、。・￥‘｛＋＊｝＜＞？＿abcdefghijklmnopqrstuvwxwzABCDEFGHIJKLMNOPQRSTUVWXYZ寿限無（じゅげむ）寿限無、五劫（ごこう）のすりきれ、海砂利水魚（かいじゃりすいぎょ）の水行末（すいぎょうまつ）、雲来末（うんらいまつ）、風来末（ふうらいまつ）、食う寝るところに住むところ、やぶらこ うじのぶらこうじ、パイポパイポ、パイポのシューリンガン、シューリンガンのグーリンダイ、グーリンダイのポンポコピーのポンポコナの長久命（ちょうきゅうめい）の長助\r\n",
				str);

		viewer.setPosition(9);
		str = viewer.view();
		assertEquals(
				"改行が見つかるまで読み込むはず",
				"234567890-^\\!\"#$%&'()=〜|@｢;:｣､｡･\\`{+*}<>?_１２３４５６７８９０−＾￥！”＃＄％＆’（）＝〜｜@｢；：」、。・￥‘｛＋＊｝＜＞？＿abcdefghijklmnopqrstuvwxwzABCDEFGHIJKLMNOPQRSTUVWXYZ寿限無（じゅげむ）寿限無、五劫（ごこう）のすりきれ、海砂利水魚（かいじゃりすいぎょ）の水行末（すいぎょうまつ）、雲来末（うんらいまつ）、風来末（ふうらいまつ）、食う寝るところに住むところ、やぶらこ うじのぶらこうじ、パイポパイポ、パイポのシューリンガン、シューリンガンのグーリンダイ、グーリンダイのポンポコピーのポンポコナの長久命（ちょうきゅうめい）の長助\r\n",
				str.substring(1));

		viewer.setPosition(53);
		str = viewer.view();
		assertEquals(
				"改行が見つかるまで読み込むはず",
				"_１２３４５６７８９０−＾￥！”＃＄％＆’（）＝〜｜@｢；：」、。・￥‘｛＋＊｝＜＞？＿abcdefghijklmnopqrstuvwxwzABCDEFGHIJKLMNOPQRSTUVWXYZ寿限無（じゅげむ）寿限無、五劫（ごこう）のすりきれ、海砂利水魚（かいじゃりすいぎょ）の水行末（すいぎょうまつ）、雲来末（うんらいまつ）、風来末（ふうらいまつ）、食う寝るところに住むところ、やぶらこ うじのぶらこうじ、パイポパイポ、パイポのシューリンガン、シューリンガンのグーリンダイ、グーリンダイのポンポコピーのポンポコナの長久命（ちょうきゅうめい）の長助\r\n",
				str);

	}

	public void test_view_carriage_return() {
		TextViewer viewer = new TextViewer();
		String str = null;
		viewer.setFile(new File("testdata/test-carriage-return.txt"));
		viewer.setPosition(0);
		viewer.setReadingLength(10);

		str = viewer.view();
		assertEquals("改行が見つかるまで読み込むはず"//
				, "abcdefghjiklmn\r", str);

		viewer.setPosition(viewer.getEndPosition());
		str = viewer.view();
		assertEquals("改行の次から読み込めるはず"//
				, "opqrs\r", str);

		viewer.setPosition(12);
		str = viewer.view();
		assertEquals("改行が見つかるまで読み込むはず"//
				, "mn\ropqrs\r", str);

	}

	public void test_view_line_feed() {
		TextViewer viewer = new TextViewer();
		String str = null;
		viewer.setFile(new File("testdata/test-line-feed.txt"));
		viewer.setPosition(0);
		viewer.setReadingLength(10);

		str = viewer.view();
		assertEquals("改行が見つかるまで読み込むはず"//
				, "abcdefghjiklmn\n", str);

		viewer.setPosition(viewer.getEndPosition());
		str = viewer.view();
		assertEquals("改行の次から読み込めるはず"//
				, "opqrs\n", str);

		viewer.setPosition(12);
		str = viewer.view();
		assertEquals("改行が見つかるまで読み込むはず"//
				, "mn\nopqrs\n", str);

	}

	private void test_viewCommonAllText(String str) {
		assertFalse("読み込み結果確認 str=" + str,//
				-1 == str.indexOf( //
						"安以宇衣於1234567890-^" //
								+ YEN_REGEX + "!\"#$%&'()=" //
						));
		// assertTrue("～は文字コードマッピングの都合でテスト対象外読み込み結果確認 str=" + str,//
		// -1 == str.indexOf( //
		// "～" //
		// ));
		assertFalse("読み込み結果確認 str=" + str,//
				-1 == str.indexOf( //
						"|@｢;:｣､｡" //
								+ "･" + YEN_REGEX + "`{+*}<>?_"//
								+ "１２３４５６７８９０" //
						));
		// assertFalse("読み込み結果確認 str=" + str,//
		// -1 == str.indexOf( //
		// "－" //
		// ));
		assertFalse("読み込み結果確認 str=" + str,//
				-1 == str.indexOf( //
						"＾" //
						));
		assertFalse("読み込み結果確認 str=" + str,//
				-1 == str.indexOf( //
						"￥！”＃＄％＆’（）＝" //
						));
		// assertTrue("～は文字コードマッピングの都合でテスト対象外読み込み結果確認 str=" + str,//
		// -1 == str.indexOf( //
		// "～" //
		// ));
		assertFalse(
				"読み込み結果確認 str=" + str,//
				-1 == str.indexOf( //
						"｜@｢；：」、。・￥‘｛＋＊｝＜＞？＿"//
								+ "abcdefghijklmnopqrstuvwxwzABCDEFGHIJKLMNOPQRSTUVWXYZ"
								//
								+ "寿限無（じゅげむ）寿限無、五劫（ごこう）のすりきれ、海砂利水魚（かいじゃりすいぎょ）の水行末" //
								+ "（すいぎょうまつ）、雲来末（うんらいまつ）、風来末（ふうらいまつ）、食う寝るところに住むところ、"
								//
								+ "やぶらこ うじのぶらこうじ、パイポパイポ、パイポのシューリンガン、シューリンガンのグーリンダイ、"
								//
								+ "グーリンダイのポンポコピーのポンポコナの長久命（ちょうきゅうめい）の長助" //
								+ "\r\nあいうえお\r\nかきくけこ\r\nさしすせそ"//
						));
	}

	public void test_viewToCrLfBackward() throws UnsupportedEncodingException {
		TextViewer viewer = new TextViewer();
		File file = new File("testdata/test4page.txt");
		viewer.setFile(file);
		viewer.setEncoding(TextViewer.SHIFT_JIS);

		byte[] rtn = null;
		long pos = file.length() - 1;
		rtn = viewer.readLineBackward(pos);
		assertEquals("LMNOP", new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		rtn = viewer.readLineBackward(pos);
		assertEquals("\r\n", new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		rtn = viewer.readLineBackward(pos);
		assertEquals("ABCDEFGHIJK\r\n", new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		rtn = viewer.readLineBackward(pos);
		assertEquals("klmnopqrstuvwxyz\n",
				new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		rtn = viewer.readLineBackward(pos);
		assertEquals("fghij\r", new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		rtn = viewer.readLineBackward(pos);
		assertEquals("abcde\n", new String(rtn, viewer.getEncoding()));

		pos = pos - rtn.length;
		try {
			rtn = viewer.readLineBackward(pos);
		} catch (FileEdgeException fe) {
			assertTrue(true);
		}
	}

	public void test_viewToCrLfForward() throws UnsupportedEncodingException {
		TextViewer viewer = new TextViewer();
		viewer.setFile(new File("testdata/test4page.txt"));
		viewer.setEncoding(TextViewer.SHIFT_JIS);

		byte[] rtn = null;
		long pos = 0;
		rtn = viewer.readLineForward(pos);
		assertEquals("abcde\n", new String(rtn, viewer.getEncoding()));

		pos = pos + rtn.length;
		rtn = viewer.readLineForward(pos);
		assertEquals("fghij\r", new String(rtn, viewer.getEncoding()));

		pos = pos + rtn.length;
		rtn = viewer.readLineForward(pos);
		assertEquals("klmnopqrstuvwxyz\n",
				new String(rtn, viewer.getEncoding()));

		pos = pos + rtn.length;
		rtn = viewer.readLineForward(pos);
		assertEquals("ABCDEFGHIJK\r\n", new String(rtn, viewer.getEncoding()));

		pos = pos + rtn.length;
		rtn = viewer.readLineForward(pos);
		assertEquals("\r\n", new String(rtn, viewer.getEncoding()));

		pos = pos + rtn.length;
		rtn = viewer.readLineForward(pos);
		assertEquals("LMNOP", new String(rtn, viewer.getEncoding()));
	}
}
