package jp.que.ti.yhj.less.than.more.sw;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.SwingUtilities;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class ForwardForeverActionListener extends
		LessThanMoreBaseActionListener {

	private static ForwardCallable forwardCallable = null;
	static String TAIL_F_MESSAGE = "Waiting for data... (interrupt to abort (Ctrl + shift + C))";

	@Override
	public void actionPerformed(ActionEvent e) {

		if (forwardCallable == null) {
			forwardCallable = new ForwardCallable(this);
		}
		// ForwardCallable rnbl = new ForwardCallable(this);
		ForwardCallable rnbl = forwardCallable;

		// すべてのメニューアイテムを無効化
		getController().getMenuConfig().setEnabledAllMenus(false);
		getController().getMenuConfig().getMenuItems().get(MenuConfig.CANCEL)
				.setEnabled(true);// キャンセルメニューのみは有効にしておく
		// フレーム内のユーザIOオブジェクトを無効化
		getController().getFrame().setEnabledAllMenus(false);

		getController().getMenuConfig().isLoop4ForwardForeverActionListener = true;
		getController().getExecutorService().submit(rnbl);
		// 終了を待たずにイベントディスパッチスレッドをすすめるため、Future オブジェクトは受けとらない
	}

	final static String EMPTY_STRING = "";

	static class ForwardCallable implements Callable<String> {
		protected final Logger log = Logger.getLogger(getClass().getName());
		ForwardForeverActionListener forwardForeverActionListener;
		private SwingGuiUpdateRunnable swingGuiUpdateRunnable;

		ForwardCallable(
				ForwardForeverActionListener forwardForeverActionListener) {
			this.forwardForeverActionListener = forwardForeverActionListener;
			this.swingGuiUpdateRunnable = new SwingGuiUpdateRunnable(
					forwardForeverActionListener);
		}

		private static final int READING_LENGTH = 1024;

		@Override
		public String call() {
			final LessThanMoreSwingFrameController controller = forwardForeverActionListener
					.getController();

			int tmpReadingLength = controller.getViewer().getReadingLength();
			controller.getViewer().setReadingLength(READING_LENGTH);

			// ステータスメッセージに、tail -f 実行中であることを表示 (イベントディスパッチイベント内で実行)
			SwingUtilities.invokeLater(new Runnable() {
				@Override
				public void run() {
					controller.getFrame().setStatusMessage(TAIL_F_MESSAGE);
				}
			});

			while (controller.getMenuConfig().isLoop4ForwardForeverActionListener) {
				final TextViewer viewer = controller.getViewer();
				if (viewer.isFileEndPosition()) {
					// ファイルの終端なので次ページを読み込まない
					// ファイルの終端にいる場合はしばらく休む
					try {
						Thread.sleep(2000);
					} catch (InterruptedException e) {
					}
				} else {
					try {
						controller.viewNextPage();
						// view の書き換えはイベントディスパッチスレッドに任せる
						SwingUtilities.invokeAndWait(swingGuiUpdateRunnable);

					} catch (InterruptedException e) {
						log.log(Level.INFO, e.getMessage(), e);
						controller.setStatusMessage(e);
					} catch (InvocationTargetException e) {
						log.log(Level.INFO, e.getMessage(), e);
						controller.setStatusMessage(e);
					} catch (RuntimeException e) {
						log.log(Level.INFO, e.getMessage(), e);
						controller.setStatusMessage(e);
					}
					try { // ほんのちょっとだけ休む
						Thread.sleep(5);
					} catch (InterruptedException e) {
					}
				}
			}
			controller.getViewer().setReadingLength(tmpReadingLength);

			// ステータスメッセージをクリア (イベントディスパッチイベント内で実行)
			SwingUtilities.invokeLater(new Runnable() {
				@Override
				public void run() {
					controller.getFrame().setStatusMessage(
							ForwardForeverActionListener.EMPTY_STRING);
				}
			});

			return ForwardForeverActionListener.EMPTY_STRING;
		}
	}

	static class SwingGuiUpdateRunnable implements Runnable {
		protected final Logger log = Logger.getLogger(getClass().getName());
		ForwardForeverActionListener forwardForeverActionListener;

		SwingGuiUpdateRunnable(
				ForwardForeverActionListener forwardForeverActionListener) {
			this.forwardForeverActionListener = forwardForeverActionListener;
		}

		@Override
		public void run() {
			final LessThanMoreSwingFrameController controller = forwardForeverActionListener
					.getController();
			try {
				controller.update();
			} catch (RuntimeException e) {
				log.log(Level.INFO, e.getMessage(), e);
				controller.setStatusMessage(e);
			}

			if (controller.getMenuConfig().isLoop4ForwardForeverActionListener) {
				if (ForwardForeverActionListener.TAIL_F_MESSAGE
						.equals(controller.getFrame().getStatusMessage())) {
					// 表示する内容が同じなので設定しない
				} else {
					// ステータスメッセージに、tail -f 実行中であることを表示
					controller.getFrame().setStatusMessage(TAIL_F_MESSAGE);
				}
			} else {
				controller.clearStatusMessage();
			}
		}
	}
}
