/*
 * created  2008/08/12 
 * Copyright 2008 yhj All rights reserved.
 */
package jp.que.ti.yhj.less.than.more.command;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.que.ti.yhj.less.than.more.TextViewer;

/**
 * 前方文字列検索する命令クラス
 * 
 * @author yhj
 * @author $Author$ (last modified)
 * @version $Revision$
 */
public class SearchForwardCMD extends SearchBaseCMD {
	/** コンストラクタ */
	public SearchForwardCMD() {
		super();
	}

	/**
	 * コンストラクタ
	 * 
	 * @param textViewer
	 *            {@link TextViewer} オブジェクト
	 * @param searchWord
	 *            検索文字列
	 */
	public SearchForwardCMD(TextViewer textViewer, String searchWord) {
		super(textViewer, searchWord);
	}

	/**
	 * 後方文字列検索を実行し、検索した見つけた文字列を読み込み先頭位置にします。<br>
	 * 検索文字列を先頭に設定した文字列は{@link #getTextViewer()} で取得したオブジェクトに対して
	 * {@link TextViewer#getLastViewCache()} を発行して取得できます。
	 * 
	 * @see jp.que.ti.yhj.less.than.more.command.CommandInterface#execute()
	 */
	@Override
	public void execute() {
		if (getTextViewer().getPosition() >= getTextViewer().getFile().length() - 1) {
			return;
		}

		boolean notEnd = true;
		Pattern pattern = Pattern.compile(getSearchWord());
		getTextViewer().setPosition(getTextViewer().getPosition() + 1);
		String str = getTextViewer().view();

		while (notEnd) {
			final Matcher mtch = pattern.matcher(str);
			notEnd = !(mtch.find());
			if (notEnd) {
				if (log.isLoggable(infoLogLevel)) {// ログ出力
					final String infoMsg = "Now searching at position="
							+ getTextViewer().getPosition() + " searchWord="
							+ getSearchWord();
					log.log(infoLogLevel, infoMsg);
				}

				try {
					str = getTextViewer().viewNextPage();
				} catch (IllegalPositionException e) {
					notEnd = false;
					getTextViewer().setPosition(
							getTextViewer().getFile().length());
					str = getTextViewer().view();
					throw e;
				}
			} else {
				int pos = mtch.start();
				String frontStr = str.substring(0, pos);
				byte[] frontBytes = null;
				try {
					frontBytes = frontStr.getBytes(getTextViewer()
							.getEncoding());
				} catch (UnsupportedEncodingException e) {
					throw new RuntimeException(e);
				}
				getTextViewer().setPosition(
						getTextViewer().getPosition() + frontBytes.length);
				str = getTextViewer().view();
			}
		}
	}
}
