package jp.que.ti.yhj.utils.file;

/**
 * フィルター対象のファイル
 * 
 * @author Hajime.Yanagawa
 * @author $Author: yanagawa.hajime $ (last modified)
 * @version $Revision: $
 */
public interface FilteredFile {
	/**
	 * この抽象パス名が示すファイルがディレクトリであるかどうかを判定します
	 * 
	 * @return この抽象パス名が示すファイルが存在し、さらにそれがディレクトリである場合は true、そうでない場合は false
	 */
	public abstract boolean isDirectory();

	/**
	 * この抽象パス名が示すファイルまたはディレクトリの名前を返します。これは、パス名の名前シーケンスの最後の名前です。パス名の名前シーケンスが空の場合、空の文字列が返されます。
	 * 
	 * @return この抽象パス名が示すファイルまたはディレクトリの名前。このパス名の名前シーケンスが空の場合は空の文字列
	 */
	public abstract String getName();
}
