package jp.que.ti.yhj.utils;

import java.io.Console;

public final class ConsoleUtils {

	private ConsoleUtils() {
	}

	/**
	 * コンソールに yes or no を入力させるメソッドです。
	 * 
	 * @return yes または、y が入力された場合、true、no または、n が入力された場合 false
	 */
	public static boolean isInputYes() {
		return isInputYes("yes(y) or no(n) を入力してください : ");
	}

	/**
	 * コンソールに yes or no を入力させるメソッドです。また、引数に指定したメッセージをコンソールに表示させます
	 * 
	 * @param message
	 *            yes or no の入力を促すためにコンソールに表示するメッセージ。
	 * @return yes または、y が入力された場合、true、no または、n が入力された場合 false
	 */
	public static boolean isInputYes(String message) {
		Console console = System.console();
		String sysin = null;
		boolean rtn = false;
		boolean notEnd = true;
		while (notEnd) {
			sysin = console.readLine(message);
			if (isEmpty(sysin)) {
				continue;
			} else if ("y".equals(sysin) || "yes".equals(sysin)) {
				rtn = true;
				notEnd = false;
			} else if ("n".equals(sysin) || "no".equals(sysin)) {
				rtn = false;
				notEnd = false;
			} else {
				continue;
			}
		}
		return rtn;
	}

	private static boolean isEmpty(String prm) {
		if (prm == null || "".equals(prm.trim())) {
			return true;
		} else {
			return false;
		}

	}

	/** コンソールからの入力結果を返却します */
	public static String in() {
		return in(null);
	}

	/** コンソールからの入力結果を返却します */
	public static String in(String inputItemName) {
		Console console = System.console();
		final String sysin = console.readLine(prompt4input(inputItemName));
		return sysin;
	}

	/** コンソールからの入力結果を返却します */
	public static String in4Password(String inputItemName) {
		Console console = System.console();
		final String sysin = new String(console.readPassword(//
				prompt4input(inputItemName)));
		return sysin;
	}

	private static String prompt4input(String inputItemName) {
		String message = null;
		if (isEmpty(inputItemName)) {
			message = "入力してください:";
		} else {
			message = "\"" + inputItemName + "\" を入力してください:";
		}
		return message;
	}
}
