package jp.que.ti.yhj.utils;

import java.util.List;
import java.util.regex.Pattern;

/**
 * 文字列に関するユーティリティー
 *
 * @author Hajime.Yanagawa
 * @author $Author: yanagawa.hajime $ (last modified)
 * @version $Revision: $
 */
public class StringUtils {
	private StringUtils() {
	}

	/** 改行文字 */
	public static final String LINE_SEPARATOR;
	static {
		String st = null;
		try {
			st = System.getProperty("line.separator");
		} catch (Exception e) {
			st = "\n";
		}
		if (st == null) {
			st = "\n";
		}
		LINE_SEPARATOR = st;
	}

	/** 円マークの{@link Pattern} */
	private static final Pattern YEN_PATTERN = Pattern.compile("\\\\");

	/**
	 * システムに依存するデフォルトのファイル名の区切り文字を"/"に統一するため、プロパティー値中の"\"を"/"に変換して返却します。
	 *
	 * @param filePathString
	 * @return ファイル名の区切り文字を"/"に統一した文字列
	 */
	public static String yen2Slash(String filePathString) {
		if (filePathString == null) {
			return filePathString;
		}
		final String rtn = YEN_PATTERN.matcher(filePathString).replaceAll("/");
		return rtn;
	}

	/**
	 * 文字列が空であるかを判定する
	 *
	 * @param str
	 *            判定対象文字列
	 * @return null、空文字、半角スペースのみで構成された文字列、の場合、true。それ以外は false
	 */
	public static boolean isEmpty(String str) {
		if (str == null || "".equals(str.trim())) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 文字列に含まれている引数 source の文字を、引数 dist の文字列に変更する
	 *
	 * @param source
	 *            変更前の文字。
	 * @param dist
	 *            変更後の文字。
	 * @param stringSource
	 *            リプレース対象の文字列全体
	 * @return 変更後の文字列。引数 stringSource の参照を返却する
	 */
	public static char[] replace(char source, char dist, char[] stringSource) {
		for (int idx = 0; idx < stringSource.length; idx++) {
			if (stringSource[idx] == source) {
				stringSource[idx] = dist;
			}
		}
		return stringSource;
	}
}
