package jp.que.ti.yhj.utils.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import jp.que.ti.yhj.utils.StringUtils;

/**
 * コンソールにプレーンな情報を出力するために作成されたシンプルなロギングフォーマッタ
 * 
 * @author Hajime.Yanagawa
 * @author $Author: yanagawa.hajime $ (last modified)
 * @version $Revision$
 */
public class SimpleFormatter extends Formatter {
	/** 改行文字 */
	private final String LINE_SEPARATOR = StringUtils.LINE_SEPARATOR;

	/**
	 * レベル文字列に続き、メッセージを出力するシンプルなフォーマット
	 * 
	 * @see java.util.logging.Formatter#format(LogRecord)
	 */
	@Override
	public String format(LogRecord record) {
		StringBuilder sb = new StringBuilder();
		sb.append(record.getLevel().getLocalizedName());
		sb.append(": ");
		sb.append(record.getMessage());
		sb.append(LINE_SEPARATOR);
		if (record.getThrown() != null) {
			try {
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				record.getThrown().printStackTrace(pw);
				pw.close();
				sb.append(sw.toString());
			} catch (Exception ex) {
			}
		}
		return sb.toString();
	}
}
