/***********************************************************
	ar.h
***********************************************************/
#include <stdio.h>
#include <stdint.h>
#include <limits.h>
#include <sys/types.h>

#define MAXDICBIT 16            /* 12(-lh4-), 13(-lh5-), 15(-lh6-), 16(-lh7-)*/
#define MAXDICSIZ (1U << MAXDICBIT)
#define MATCHBIT   8            /* bits for MAXMATCH - THRESHOLD */
#define MAXMATCH 256            /* formerly F (not more than UCHAR_MAX + 1) */
#define THRESHOLD  3            /* choose optimal value */

#define NC (UCHAR_MAX + MAXMATCH + 2 - THRESHOLD)
        /* alphabet = {0, 1, 2, ..., NC - 1} */
#define CBIT 9                  /* $\lfloor \log_2 NC \rfloor + 1$ */
#define CODE_BIT  16            /* codeword length */

#define NP (MAXDICBIT + 1)      /* max value of np */
#define NT (CODE_BIT + 3)
#if 0 /* Use the pbit variable instead of PBIT */
#define PBIT 4                  /* smallest integer such that (1U << PBIT) > NP */
#endif
#define TBIT 5                  /* smallest integer such that (1U << TBIT) > NT */

struct lzh_istream {
    FILE *fp;
    off_t compsize;

    uint16_t bitbuf;
    uint8_t subbitbuf;
    int bitcount;

    /* huf.c */
    unsigned int blocksize;

    uint8_t  c_len[NC];
    uint16_t c_table[4096];
    uint16_t c_left[2 * NC - 1], c_right[2 * NC - 1];

    uint8_t  p_len[NP];
    uint16_t p_table[256];
    uint16_t p_left[2 * NP - 1], p_right[2 * NP - 1];

    int np;
    int pbit;
};

struct lzh_ostream {
    FILE *fp;
    off_t compsize;
    off_t origsize;
    int unpackable;

    uint8_t subbitbuf;
    int bitcount;

    uint16_t crc;

    /* huf.c */
    uint8_t *buf;
    size_t bufsiz;

    /* huf.c:output() */
    size_t output_pos, output_mask;
    size_t cpos;

    uint16_t c_freq[2 * NC - 1];
    uint16_t p_freq[2 * NP - 1];

    int np;
    int pbit;
};

struct lzh_header {
    char filename[1024];
    int  namelen;
    char method[5];
    off_t compsize;
    off_t origsize;
    time_t mtime;
    uint16_t file_crc;
    char os_id;
    int level;
};

struct lha_method {
    char *id;
    int dicbit;
    int pbit;
    int maxmatch;
};

struct lha_opts {
    int nocompress;
    char *outdir;
    int quiet;
    int header_level;
    int generic;
    int verbose;
    int force_extract;
    int archive_to_stdio;

    /* compress parameter */
    struct lha_method *method;

    /* working variable */
    int has_wildcard;
};
#define INITIALIZE_OPTS(opts)                   \
    do {                                        \
        (opts).nocompress = 0;                  \
        (opts).outdir = NULL;                   \
        (opts).quiet = 0;                       \
        (opts).header_level = 2;                \
        (opts).generic = 0;                     \
        (opts).verbose = 0;                     \
        (opts).force_extract = 0;               \
        (opts).archive_to_stdio = 0;            \
                                                \
        /* default is the -lh5- method */       \
        (opts).method   = &methods[5];          \
        (opts).has_wildcard = 0;                \
    } while (0)

/* ar.c */
extern struct lha_opts opts;

/* io.c */

#define INIT_CRC  0             /* CCITT: 0xFFFF */
#define UPDATE_CRC(crc, c) \
    (crc) = crctable[((crc) ^ (unsigned char)(c)) & 0xFF] ^ ((crc) >> CHAR_BIT)

#define BITBUFSIZ (CHAR_BIT * sizeof(unsigned short)) /* size of bitbuf */

/* utilities */
#define MIN(a, b) (((a) > (b)) ? (b) : (a))

#include "prototypes.h"
