/**
 * @file  CpuMap.cpp
 * @brief CPU ԍ CPU  APIC ID ̃}bvNX.
 *
 * @author JIN
 *
 * Copyright (C) 2008- JIN All rights reserved.
 */
#include "StdAfx.h"
#include "MathUtility.h"
using namespace Math;

#include "CpuMap.h"

#include <limits>

#ifdef _WIN32
#include <intrin.h>
#else	// #ifdef _WIN32
#error "__cpuid intrinsic required."
#endif	// #ifdef _WIN32

// TODO: }`vZbTA64 rbgeXg
#ifdef _WIN64
#pragma message("TODO: eXg")
#endif	// #ifdef _WIN64

namespace GenericUtility {

namespace {

/**
 * SSE2 gp\ǂ.
 */
bool CheckIsSSE2Available()
{
	// 0: eax, 1: ebx, 2: ecx, 3: edx
	int CPUInfo[4];

	// cpuid(0)
	__cpuid(CPUInfo, 0);
	// CPUInfo[0] (eax) : cpuid  eax Ɏwłőԍ
	// cpuid(1) T|[gĂȂ
	if (CPUInfo[0] == 0)
		return false;

	// cpuid(1)
	__cpuid(CPUInfo, 1);

	// CPUInfo[3] (edx) / bit 26 : SSE2
	return (CPUInfo[3] >> 26) & 0x01;
}

}	// anonymous namespace

/////////////////////////////////////////////////////////////////////////////

CCpuMap::CCpuMap()
{
	// SSE2 gp\ǂ
	m_bSSE2Available = CheckIsSSE2Available();

	// VXevZbT擾
	SYSTEM_INFO si;
	::GetSystemInfo(&si);
	m_dwNumberOfProcessors = si.dwNumberOfProcessors;
	ASSERT(1 <= m_dwNumberOfProcessors && m_dwNumberOfProcessors <= std::numeric_limits<DWORD_PTR>::digits);

	// ݂̃vZX
	HANDLE hCurrentProcess = ::GetCurrentProcess();

	// ݂̃vZX Affinity Mask 擾
	DWORD_PTR dwSystemAffinityMask;
	if (!::GetProcessAffinityMask(hCurrentProcess, &m_dwProcessAffinityMask, &dwSystemAffinityMask)) {
#if 0
		// HACK: LSB 珇ԂɗĂƂ݂Ȃ
		m_dwProcessAffinityMask = (1 << m_dwNumberOfProcessors) - 1;
#else
		// HACK: G[ƂĈ
		m_dwProcessAffinityMask = 0;
#endif
		// HACK: ׂĎgp\Ƃ݂Ȃ
		m_dwProcessAffinityBits = m_dwNumberOfProcessors;
		return;
	}
	m_dwProcessAffinityBits = static_cast<DWORD>(population(m_dwProcessAffinityMask));

	// VOvZbT
	if (m_dwNumberOfProcessors == 1) {
		return;
	}

	// Affinity Mask ɑΉrbg
	DWORD_PTR dwBit = 1;
	for (DWORD i = 0; i < m_dwNumberOfProcessors && dwBit <= dwSystemAffinityMask; ++i, dwBit <<= 1) {
		// VXe Affinity Mask ɑΉrbgĂȂ΃XLbv
		// (Affinity Mask ݒłȂ)
		if (!(dwSystemAffinityMask & dwBit))
			continue;

		// vZX Affinity Mask ݒ肷
		// (w肵 CPU łsłȂ悤ɂ)
		if (!::SetProcessAffinityMask(hCurrentProcess, dwBit))
			continue;
		// w肵 CPU Ŏs悤ɁÃ݂Xbh̎c̃^CXCX
		::Sleep(0);

		// APIC ID 擾
		m_ApicId[i] = GetApicId();
	}

	// vZX Affinity Mask ɖ߂
	VERIFY(::SetProcessAffinityMask(hCurrentProcess, m_dwProcessAffinityMask));
	::Sleep(0);
}

CCpuMap::~CCpuMap()
{
}

CCpuMap& CCpuMap::Instance()
{
	static CCpuMap instance;
	return instance;
}

bool CCpuMap::IsSSE2Available() const
{
	return m_bSSE2Available;
}

DWORD CCpuMap::GetNumberOfProcessors() const
{
	return m_dwNumberOfProcessors;
}

DWORD CCpuMap::GetCurrentProcessAffinityBits() const
{
#if 1
	// HACK: N̐lgp
	// HACK: (sɕύX邱Ƃ͑z肵ĂȂ)
	return m_dwProcessAffinityBits;
#else
	// vZX Affinity Mask 擾
	DWORD_PTR dwProcessAffinityMask;
	if (!GetCurrentProcessAffinityMask(dwProcessAffinityMask)) {
		// HACK: 擾ɎsAVXẽvZbTԂ
		return m_dwNumberOfProcessors;
	}

	// vZX Affinity Mask  1 ̃rbg
	return population(dwProcessAffinityMask);
#endif
}

bool CCpuMap::GetCurrentProcessAffinityMask(DWORD_PTR& dwProcessAffinityMask) const
{
#if 1
	// HACK: N Affinity Mask gp
	// HACK: (sɕύX邱Ƃ͑z肵ĂȂ)
	dwProcessAffinityMask = m_dwProcessAffinityMask;
	return dwProcessAffinityMask != 0;
#else
	// vZX Affinity Mask 擾
	// (sɕύX\̂ŁA̓sx擾)
	DWORD_PTR dwSystemAffinityMask;
	return ::GetProcessAffinityMask(::GetCurrentProcess(), &dwProcessAffinityMask, &dwSystemAffinityMask) ? true : false;
#endif
}

int CCpuMap::GetCurrentProcessorNumber()
{
	// VOvZbT
	// HACK: 0 ƌߑłĂ
	if (m_dwNumberOfProcessors == 1)
		return 0;

	// ݎs CPU  APIC ID
	ApicIdType apic = GetApicId();
	if (!apic)
		return -1;

	// APIC ID ̂T
	for (DWORD i = 0; i < m_dwNumberOfProcessors; ++i) {
		// APIC ID ̂
		if (m_ApicId[i] && *m_ApicId[i] == *apic)
			return i;
	}

	// APIC ID ̂Ȃ
	return -1;
}

CCpuMap::ApicIdType CCpuMap::GetApicId()
{
	static const ApicIdType error;

	// 0: eax, 1: ebx, 2: ecx, 3: edx
	int CPUInfo[4];

	// cpuid(0)
	__cpuid(CPUInfo, 0);
	// CPUInfo[0] (eax) : cpuid  eax Ɏwłőԍ
	// cpuid(1) T|[gĂȂ
	if (CPUInfo[0] == 0)
		return error;

	// cpuid(1)
	__cpuid(CPUInfo, 1);
#if 0
	// CPUInfo[3] (edx) / bit 9 : APIC (On-chip APIC Hardware)
	// local APIC T|[gĂȂ (svH)
	if ((CPUInfo[3] & (1 << 9)) == 0)
		return error;
#endif

	// CPUInfo[1] (ebx) / bit 31-24 : APIC ID
	return (BYTE)((CPUInfo[1] >> 24) & 0xFF);
}

}	// namespace GenericUtility
