/**
 * @file  DialogPositionSaver.h
 * @brief _CAOʒuۑ/NX`.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef ___DIALOGUTILITY_DIALOGPOSITIONSAVER_H
#define ___DIALOGUTILITY_DIALOGPOSITIONSAVER_H

namespace DialogUtility {

/////////////////////////////////////////////////////////////////////////////
/**
 * _CAOʒuۑ/.
 */
class CDialogPositionSaver
{
public:
	CDialogPositionSaver();

	/**
	 * _CAOʒuۑ.
	 */
	bool Save(CWnd* pWnd);
	/**
	 * _CAOʒu𕜌.
	 */
	bool Restore(CWnd* pWnd);

	/**
	 * eNA.
	 */
	void Reset();
	/**
	 * eLǂ擾.
	 */
	bool IsValid() const;

	/**
	 * _CAÖʒu擾.
	 * (ő剻/ŏĂƂ́Aɖ߂Ƃ̈ʒu)
	 */
	const CRect& GetRect() const;
	/**
	 * _CAO̕\Ԃ擾.
	 * (SW_SHOWNORMAL/SW_SHOWMAXIMIZED/SW_SHOWMINIMIZED)
	 */
	UINT GetShowCmd() const;

private:
	/// _CAÖʒu
	/// (ő剻/ŏĂƂ́Aɖ߂Ƃ̈ʒu)
	CRect m_rc;
	/// ŏ\̃tO
	/// (WPF_RESTORETOMAXIMIZED)
	/// @see WINDOWPLACEMENT::flags
	UINT m_flags;
	/// _CAO̕\
	/// (SW_SHOWNORMAL/SW_SHOWMAXIMIZED/SW_SHOWMINIMIZED)
	/// @see WINDOWPLACEMENT::showCmd
	UINT m_showCmd;

private:
	friend class boost::serialization::access;
	template<class Archive>
	void serialize(Archive& ar, const unsigned int version)
	{
		using boost::serialization::make_nvp;
		ar & make_nvp("Left", m_rc.left);
		ar & make_nvp("Top", m_rc.top);
		ar & make_nvp("Right", m_rc.right);
		ar & make_nvp("Bottom", m_rc.bottom);
		if (version >= 1) {
			ar & make_nvp("Flags", m_flags);
			ar & make_nvp("ShowCmd", m_showCmd);
		}
	}
};

/////////////////////////////////////////////////////////////////////////////
/**
 * XgRg[̃Jۑ/.
 */
class CListColumnWidthSaver
{
public:
	/**
	 * Jۑ.
	 */
	bool Save(CListCtrl* pList);
	/**
	 * J𕜌.
	 */
	bool Restore(CListCtrl* pList);

private:
	typedef std::vector<int> IntVec;
	IntVec m_Widths;

private:
	friend class boost::serialization::access;
	template<class Archive>
	void serialize(Archive& ar, const unsigned int version)
	{
		using boost::serialization::make_nvp;
		ar & make_nvp("Widths", m_Widths);
	}
};

/////////////////////////////////////////////////////////////////////////////
/**
 * Rg[̃tHgTCYۑ/.
 */
class CWndFontSaver
{
public:
	CWndFontSaver();

	/**
	 * tHgTCYۑ.
	 */
	bool Save(CWnd* pWnd);
	/**
	 * tHgTCY𕜌.
	 */
	bool Restore(CWnd* pWnd);

private:
	LONG m_height;

private:
	friend class boost::serialization::access;
	template<class Archive>
	void serialize(Archive& ar, const unsigned int version)
	{
		using boost::serialization::make_nvp;
		ar & make_nvp("Height", m_height);
	}
};

}	// namespace DialogUtility

BOOST_CLASS_VERSION(DialogUtility::CDialogPositionSaver, 1);

#endif
