<?xml version='1.0' encoding='UTF-8'?>

<!DOCTYPE xsl:stylesheet [
    <!ENTITY nbsp "&#160;">
]>

<xsl:stylesheet xmlns:xalan="http://xml.apache.org/xslt" version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="iso-8859-1" indent="yes" />

	<xsl:template match="rialto">

		<xsl:text disable-output-escaping="yes">
			<![CDATA[
			<%@ taglib uri="http://rialto.application-servers.com/tags-jsf" prefix="rialto"%>
			<%@ taglib prefix="f" uri="http://java.sun.com/jsf/core" %>
			<%@ taglib prefix="h" uri="http://java.sun.com/jsf/html" %>
			]]>
		</xsl:text>

			<rialto:view name="myView">
				<xsl:apply-templates />
			</rialto:view>
			
	</xsl:template>


	<xsl:template match="simpleWindow">
		<rialto:window id="{@name}" title="{@title}" icon="{@icone}">
			<xsl:apply-templates />
		</rialto:window>
	</xsl:template>

	<xsl:template match="popup">
		<rialto:popup id="{@name}" title="{@title}" top="{@top}"
			left="{@left}" width="{@width}" height="{@height}">
			<xsl:if test="@fond='gris'">
				<xsl:attribute name="greyBackground">
					true
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@fond!='gris'">
				<xsl:attribute name="greyBackground">
					false
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates />
		</rialto:popup>
	</xsl:template>

	<!-- 	alert non support辿 
		<xsl:template match="alert">
		<rialto:alert name="{@name}" title="{@title}"/>
		</xsl:template>	
	-->

	<xsl:template match="image">
		<rialto:image id="{@name}" alt="{@alt}" pref2="{@imageOut}"
			imageDisabled="{@imageDisabled}" top="{@top}" left="{@left}"
			pref1="{@imageOn}" floatLeft="{@boolFloatLeft}"
			floatRight="{@boolFloatRight}" />
	</xsl:template>


	<xsl:template match="splitter">
		<rialto:splitter id="{@name}" prop="{@prop}"
			orientation="{@orientation}" top="{@top}" left="{@left}"
			width="{@width}" height="{@height}" style="{@style}"
			limInf="{@limInf}" limSup="{@limSup}" withImg="{@withImg}"
			reverseClose="{@reverseClose}">

			<xsl:for-each select="divSplitter">
				<rialto:divSplit id="div{position()}"
					backgroundColor="{@backgroundColor}">
					<xsl:apply-templates />
				</rialto:divSplit>
			</xsl:for-each>
		</rialto:splitter>
	</xsl:template>


	<xsl:template match="treeview">
		<rialto:treeview id="{@name}" rootOpen="{@rootOpen}"
			withRoot="{@withRoot}" withT="{@withT}"
			draggableNode="{@draggableNode}" top="{@top}" left="{@left}"
			width="{@width}" height="{@height}">
			<xsl:apply-templates />
		</rialto:treeview>
	</xsl:template>

	<xsl:template match="treenode">
		<rialto:treeNode id="{@name}" text="{@text}" icon="{@icon}"
			icon2="{@icon2}" onclick="{@onclick}" open="{@open}"
			reload="{@reload}" url="{@url}" typeInfo="{@typeInfo}">
			<xsl:apply-templates />
		</rialto:treeNode>
	</xsl:template>

	<xsl:template match="frame">
		<rialto:frame id="{@name}" title="{@title}" open="{@open}"
			top="{@top}" left="{@left}" width="{@width}" height="{@height}"
			dynamic="{@dynamic}" draggable="{@draggable}">
			<xsl:apply-templates />
		</rialto:frame>
	</xsl:template>

	<xsl:template match="form">
		<rialto:form id="{@name}" method="{@method}"
			autoSubmit="{@autoSubmit}" boolWithFenWait="{@boolWithFenWait}"
			boolAsynch="{@boolAsynch}" canBeCancel="{@canBeCancel}" url="{@url}"
			boolIframe="{@boolIframe}" onSuccess="{@onSuccess}"
			callBackObjectOnSuccess="{@callBackObjectOnSuccess}">
			<xsl:apply-templates />
		</rialto:form>
	</xsl:template>

	<xsl:template match="text">
		<rialto:text id="{@name}" type="{@type}" autoUp="{@autoUp}"
			tabIndex="{@tabIndex}" accessKey="{@accessKey}" top="{@top}"
			left="{@left}" width="{@width}" rows="{@rows}"
			initValue="{@initValue}" required="{@required}"
			disabled="{@disabled}" />
	</xsl:template>

	<xsl:template match="label">
		<rialto:label id="{@name}" value="{@text}"
			styleClass="{@className}" top="{@top}" left="{@left}" />
	</xsl:template>

	<xsl:template match="combo">
		<rialto:combo id="{@name}" top="{@top}" left="{@left}"
			width="{@width}" disabled="{@enable}" heightItem="{@heightItem}"
			suggest="{@suggest}" />
	</xsl:template>

	<xsl:template match="checkbox">
		<rialto:checkbox id="{@name}" label="{@text}"
			styleClass="{@className}" top="{@top}" left="{@left}"
			value="{@checked}" />
	</xsl:template>

	<xsl:template match="radio">
		<rialto:radio id="{@name}" label="{@text}"
			classname="{@className}" top="{@top}" left="{@left}"
			checked="{@checked}" group="{@group}" />
	</xsl:template>

	<!--  composant non support辿
		<xsl:template match="codeLabel">
		<rialto:codeLabel id="{@name}" codeWidth="{@codeWidth}"
		withLabel="{@withLabel}" top="{@top}" left="{@left}"
		submitOnload="{@submitOnload}" width="{@width}"
		alwaysRefresh="{@alwaysRefresh}" />
		</xsl:template>
	-->
	<xsl:template match="button">
		<rialto:button id="{@name}" alt="{@alt}" title="{@title}"
			enable="{@enable}" top="{@top}" left="{@left}"
			widthMin="{@widthMin}" width="{@width}" />
	</xsl:template>

	<xsl:template match="grid">
		<rialto:dataGrid id="{@name}" navig="{@bNavig}" rang="{@rang}"
			lineHeight="{@lineHeight}" writable="{@writable}" top="{@top}"
			left="{@left}" cellActive="{@cellActive}" height="{@height}"
			actifClic="{@actifClic}" sortable="{@sortable}"
			multiSelect="{@multiSelect}" switchable="{@switchable}">

			<xsl:apply-templates />

		</rialto:dataGrid>
	</xsl:template>



	<xsl:template match="gridHeader">
		<h:column>
			<f:facet name="header">
				<h:outputText value="{@title}" />
			</f:facet>
			<h:outputText value="" />
		</h:column>
	</xsl:template>
	<!-- 
		<xsl:template match="gridLine">
		<rialto:gridLine>
		<xsl:apply-templates />
		</rialto:gridLine>
		</xsl:template>
		
		<xsl:template match="gridCell">
		<rialto:gridCell value="{@value}" />
		</xsl:template>
	-->
	<xsl:template match="tabfolder">
		<rialto:tabs id="{@name}" widthTabName="{@widthTabName}"
			autoRedimTab="{@autoRedimTab}" closable="{@isClosable}"
			draggableItem="{@draggableItem}" top="{@top}" left="{@left}"
			width="{@width}" height="{@height}">
			<xsl:apply-templates />
		</rialto:tabs>
	</xsl:template>

	<xsl:template match="tabitem">
		<rialto:tab title="{@title}" id="{@name}" enable="{@enable}">
			<xsl:apply-templates />
		</rialto:tab>
	</xsl:template>
</xsl:stylesheet>