<?xml version='1.0' encoding='UTF-8'?>

<!DOCTYPE xsl:stylesheet [
    <!ENTITY nbsp "&#160;">
]>

<xsl:stylesheet xmlns:xalan="http://xml.apache.org/xslt" version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="iso-8859-1" indent="yes"/>

		<xsl:template match="rialto">
		 
		 	<xsl:text disable-output-escaping="yes"><![CDATA[
			<%@ taglib uri="taglib/src/main/resources/META-INF/tlds/rialto.tld" prefix="rialto"%>
			]]></xsl:text>
			<html encoding="ISO-8859-1">
			<head>
			<link rel="shortcut icon"  TYPE="image/ico" href="favicon.ico" />
			<title>RIALTO JSP</title> 
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			
			<rialto:import pathRialtoEngine="/rialtoEngine"/>
			<rialto:layout  name="myLayout" refParentHTML="{@toParent}">		 	
			 		  <xsl:apply-templates/>
			 	</rialto:layout>
			<body onLoad='loadLayout("myLayout");'/>
			</html>	
		</xsl:template>
	  
	      
		<xsl:template match="simpleWindow">
	    	 <rialto:window name="{@name}" title="{@title}" icone="{@icone}">
				<xsl:apply-templates/>
		     </rialto:window>
		</xsl:template>	

		<xsl:template match="popup">
	    	 <rialto:popup name="{@name}" title="{@title}" 
	    	 				top="{@top}" left="{@left}" width="{@width}" height="{@height}">
	    	 	<xsl:if test="@fond='gris'">
		    	 	<xsl:attribute name="greyBackground">true</xsl:attribute>
	    	 	</xsl:if>
	    	 	<xsl:if test="@fond!='gris'">
		    	 	<xsl:attribute name="greyBackground">false</xsl:attribute>
	    	 	</xsl:if>	    	 	
				<xsl:apply-templates/>
		     </rialto:popup>
		</xsl:template>	
		
		<xsl:template match="alert">
	    	 <rialto:alert name="{@name}" title="{@title}"/>
		</xsl:template>	
	  	
	  	<xsl:template match="image">
	    	 <rialto:image name="{@name}" alt="{@alt}" imageOut="{@imageOut}" imageDisabled="{@imageDisabled}"
				   		   top="{@top}" left="{@left}" imageOn="{@imageOn}" boolFloatLeft="{@boolFloatLeft}" boolFloatRight="{@boolFloatRight}"/>
		</xsl:template>
		
		
		<xsl:template match="splitter">
	    	 <rialto:splitter name="{@name}" prop="{@prop}" orientation="{@orientation}"
   	 						top="{@top}" left="{@left}" width="{@width}" height="{@height}"	    	 	  	 	
							style="{@style}" limInf="{@limInf}" limSup="{@limSup}" withImg="{@withImg}" reverseClose="{@reverseClose}">	    	 	  	 	
				
				<xsl:for-each select="divSplitter">
					<rialto:divSplit name="div{position()}" backgroundColor="{@backgroundColor}">	    	 	  	 	
						<xsl:apply-templates/>
				    </rialto:divSplit>
				</xsl:for-each>
		     </rialto:splitter>
		</xsl:template>	
		
				
		<xsl:template match="treeview">		
	 	    <rialto:treeview  name="{@name}" rootOpen="{@rootOpen}" withRoot="{@withRoot}" withT="{@withT}" draggableNode="{@draggableNode}"
						   	  top="{@top}" left="{@left}" width="{@width}" height="{@height}">
					<xsl:apply-templates/>
			</rialto:treeview>
		</xsl:template>
		
		<xsl:template match="treenode">		
	 	    <rialto:treeNode  name="{@name}" text="{@text}" icon="{@icon}" icon2="{@icon2}" onclick="{@onclick}" open="{@open}"
						   	  reload="{@reload}" url="{@url}" typeInfo="{@typeInfo}">
					<xsl:apply-templates/>
			</rialto:treeNode>				
		</xsl:template>
		
		<xsl:template match="frame">
	    	 <rialto:frame name="{@name}" title="{@title}" open="{@open}"
   	 						top="{@top}" left="{@left}" width="{@width}" height="{@height}"	    	 	  	 	
							dynamic="{@dynamic}" draggable="{@draggable}">
				<xsl:apply-templates/>
		     </rialto:frame>
		</xsl:template>	

		<xsl:template match="form">		
	 	    <rialto:form  name="{@name}" method="{@method}" autoSubmit="{@autoSubmit}" boolWithFenWait="{@boolWithFenWait}" boolAsynch="{@boolAsynch}"
						   	  canBeCancel="{@canBeCancel}" url="{@url}" boolIframe="{@boolIframe}" onSuccess="{@onSuccess}" callBackObjectOnSuccess="{@callBackObjectOnSuccess}">
					<xsl:apply-templates/>
			</rialto:form>
		</xsl:template>

		<xsl:template match="text">
	    	 <rialto:text name="{@name}" datatype="{@datatype}" autoUp="{@autoUp}" tabIndex="{@tabIndex}" accessKey="{@accessKey}"
   	 						top="{@top}" left="{@left}" width="{@width}" rows="{@rows}" initValue="{@initValue}"
							isRequired="{@isRequired}" disable="{@disable}"/>
		</xsl:template>	
		
		<xsl:template match="label">
	    	 <rialto:label name="{@name}" text="{@text}" classname="{@className}" top="{@top}" left="{@left}"/>
		</xsl:template>
		
		<xsl:template match="combo">
	    	 <rialto:combo name="{@name}"  top="{@top}" left="{@left}" width="{@width}"
	    	 enable="{@enable}" heightItem="{@heightItem}" suggest="{@suggest}"/>
		</xsl:template>
		
		<xsl:template match="checkbox">
	    	 <rialto:checkbox name="{@name}" text="{@text}" classname="{@className}" top="{@top}" left="{@left}" checked="{@checked}"/>
		</xsl:template>
		
		<xsl:template match="radio">
	    	 <rialto:radio name="{@name}" text="{@text}" classname="{@className}" top="{@top}" left="{@left}" checked="{@checked}" group="{@group}"/>
		</xsl:template>
		
		<xsl:template match="codeLabel">
	    	 <rialto:codeLabel name="{@name}" codeWidth="{@codeWidth}" withLabel="{@withLabel}" top="{@top}" left="{@left}" 
	    	 submitOnload="{@submitOnload}" width="{@width}" alwaysRefresh="{@alwaysRefresh}"/>
		</xsl:template>
		 
		<xsl:template match="button">
	    	 <rialto:button name="{@name}" alt="{@alt}" title="{@title}" enable="{@enable}"
				   		   top="{@top}" left="{@left}" adaptToText="{@adaptToText}" widthMin="{@widthMin}" width="{@width}"/>
		</xsl:template>
		
		<xsl:template match="grid">
	    	 <rialto:grid name="{@name}" bNavig="{@bNavig}" rang="{@rang}" lineHeight="{@lineHeight}" writable="{@writable}"
   	 						top="{@top}" left="{@left}" cellActive="{@cellActive}" height="{@height}" actifClic="{@actifClic}"	    	 	  	 	
							sortable="{@sortable}" multiSelect="{@multiSelect}" switchable="{@switchable}">
				<xsl:apply-templates/>
		     </rialto:grid>
		</xsl:template>
		
		<xsl:template match="gridHeader">
	    	 <rialto:gridHeader  title="{@title}" type="{@type}" width="{@width}"/>
		</xsl:template>	
		
		<xsl:template match="gridLine">
	    	 <rialto:gridLine>
	    	 	<xsl:apply-templates/>
	    	 </rialto:gridLine>
		</xsl:template>	
		
		<xsl:template match="gridCell">
	    	 <rialto:gridCell value="{@value}"/>
		</xsl:template>	
		
		<xsl:template match="tabfolder">
	    	 <rialto:tabFolder name="{@name}" widthTabName="{@widthTabName}" autoRedimTab="{@autoRedimTab}" isClosable="{@isClosable}" 
	    	 				   draggableItem="{@draggableItem}"	top="{@top}" left="{@left}" width="{@width}" height="{@height}">
				<xsl:apply-templates/>
		     </rialto:tabFolder>
		</xsl:template>
		
		<xsl:template match="tabitem">
	     	<rialto:tabItem  title="{@title}" name="{@name}" enable="{@enable}">
		    	 <xsl:apply-templates/>
		    </rialto:tabItem>
		</xsl:template>			
</xsl:stylesheet>