/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConstraintProperty extends AbstractMaskatPropertySource {

	public static final int METRIC_ALL = 0, METRIC_XY = 1, METRIC_XYWIDTH = 2,
			METRIC_XYHEIGHT = 4;

	private static String PROP_X = "_prop_x_";

	private static String PROP_Y = "_prop_y_";

	private static String PROP_WIDTH = "_prop_width_";

	private static String PROP_HEIGHT = "_prop_height_";

	private static IPropertyDescriptor X = new TextPropertyDescriptor(PROP_X,
			"left"), Y = new TextPropertyDescriptor(PROP_Y, "top"),
			WIDTH = new TextPropertyDescriptor(PROP_WIDTH, "width"),
			HEIGHT = new TextPropertyDescriptor(PROP_HEIGHT, "height");

	private static final IPropertyDescriptor[] METRIC_PROPDESC_ALL = new IPropertyDescriptor[] {
			X, Y, WIDTH, HEIGHT };

	private static final IPropertyDescriptor[] METRIC_PROPDESC_XY = new IPropertyDescriptor[] {
			X, Y };

	private static final IPropertyDescriptor[] METRIC_PROPDESC_XYWIDTH = new IPropertyDescriptor[] {
			X, Y, WIDTH };

	private static final IPropertyDescriptor[] METRIC_PROPDESC_XYHEIGHT = new IPropertyDescriptor[] {
			X, Y, HEIGHT };

	static {
		// emetricPropertyDescriptorvalidatort
		for (int i = 0; i < METRIC_PROPDESC_ALL.length; i++) {
			((TextPropertyDescriptor) METRIC_PROPDESC_ALL[i])
					.setValidator(new ICellEditorValidator() {
						public String isValid(Object value) {
							try {
								Integer.parseInt((String) value);
								return null;
							} catch (NumberFormatException e) {
								return "͂ĂB";
							}
						}
					});
		}
	}

	private Rectangle rect;

	private IPropertyDescriptor[] descriptors = null;

	public ConstraintProperty(Rectangle constraint, int metricType) {
		rect = constraint;
		if (metricType == METRIC_ALL)
			descriptors = METRIC_PROPDESC_ALL;
		if (metricType == METRIC_XY)
			descriptors = METRIC_PROPDESC_XY;
		if (metricType == METRIC_XYHEIGHT)
			descriptors = METRIC_PROPDESC_XYHEIGHT;
		if (metricType == METRIC_XYWIDTH)
			descriptors = METRIC_PROPDESC_XYWIDTH;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		if (descriptors != null)
			return descriptors;
		return METRIC_PROPDESC_ALL;
	}

	public Object doGetPropertyValue(Object id) {
		if (PROP_X.equals(id)) {
			return Integer.toString(rect.x);
		}
		if (PROP_Y.equals(id)) {
			return Integer.toString(rect.y);
		}
		if (PROP_WIDTH.equals(id)) {
			return Integer.toString(rect.width);
		}
		if (PROP_HEIGHT.equals(id)) {
			return Integer.toString(rect.height);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void doSetPropertyValue(Object id, Object value) {
		if (id.equals(PROP_X)) {
			rect.x = Integer.parseInt((String) value);
		}
		if (id.equals(PROP_Y)) {
			rect.y = Integer.parseInt((String) value);
		}
		if (PROP_WIDTH.equals(id)) {
			rect.width = Integer.parseInt((String) value);
		}
		if (PROP_HEIGHT.equals(id)) {
			rect.height = Integer.parseInt((String) value);
		}

	}

	public String toString() {
		return "";
	}

	public Rectangle getRect() {
		return rect;
	}
}
