/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.xml;

import org.exolab.castor.xml.OutputFormat;

public class MaskatOutputFormatForCastor implements OutputFormat {

	private MaskatOutputFormatForXerces _outputFormat;

	/**
	 * Creates an instance of this class.
	 */
	public MaskatOutputFormatForCastor() {
		_outputFormat = new MaskatOutputFormatForXerces();
	}

	public void setMethod(String method) {
		_outputFormat.setMethod(method);

	}

	public void setIndenting(boolean indent) {
		_outputFormat.setIndenting(indent);

	}

	public void setPreserveSpace(boolean preserveSpace) {
		_outputFormat.setPreserveSpace(preserveSpace);

	}

	public Object getFormat() {
		return _outputFormat;
	}

	public void setDoctype(String type1, String type2) {
		_outputFormat.setDoctype(type1, type2);

	}

	public void setOmitXMLDeclaration(boolean omitXMLDeclaration) {
		_outputFormat.setOmitXMLDeclaration(omitXMLDeclaration);
	}

	public void setOmitDocumentType(boolean omitDocumentType) {
		_outputFormat.setOmitDocumentType(omitDocumentType);
	}

	public void setEncoding(String encoding) {
		_outputFormat.setEncoding(encoding);
	}

}
