/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class TabFolderFigure extends Label {

	/**
	 * ׂẴ^uy[W\ɂ ׂẴ^u{^񊈐ɂ
	 */
	public void setAllTabPageInvisible() {
		List childrenFigure = getChildren();
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof TabPageFigure) {
				figure.setVisible(false);
			}
			if (figure instanceof TabFigure) {
				figure.setForegroundColor(Display.getCurrent().getSystemColor(
						SWT.COLOR_GRAY));
			}
		}
	}

	/**
	 * namẽ^uy[W\A^u{^
	 * 
	 * @param name
	 */
	public void showNamedTabPage(String name) {
		List childrenFigure = getChildren();
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof TabPageFigure) {
				TabPageFigure tabPage = (TabPageFigure) figure;
				if (name.equals(tabPage.getName())) {
					tabPage.setVisible(true);
				}
			}
			if (figure instanceof TabFigure) {
				TabFigure tab = (TabFigure) figure;
				if (name.equals(tab.getName())) {
					figure.setForegroundColor(Display.getCurrent()
							.getSystemColor(SWT.COLOR_BLACK));
				}
			}
		}
	}
}
