/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.Target;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class ResultProperty extends Result implements IPropertySource {

	private static String PROP_ROOTNODE = "_prop_rootnode_";

	private static String PROP_ONERRORTELE = "_prop_onerrortele_";

	private static String PROP_SOAP = "_prop_soap_";

	private static IPropertyDescriptor[] descriptors;
	static {
		descriptors = new IPropertyDescriptor[] {
				new MaskatTextPropertyDescriptor(PROP_ROOTNODE, "rootNode"),
				new MaskatTextPropertyDescriptor(PROP_ONERRORTELE, "onErrorTele"),
				new MaskatTextPropertyDescriptor(PROP_SOAP, "soap") };
	}

	public ResultProperty() {
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		List targetsPropDesc = new ArrayList();
		int i = 0;
		for (Iterator it = getTargetsIt(); it != null && it.hasNext(); i++) {
			it.next();
			targetsPropDesc.add(new PropertyDescriptor(new Integer(i), "target"));

		}
		List desc = Arrays.asList(descriptors);
		targetsPropDesc.addAll(desc);

		return (IPropertyDescriptor[]) targetsPropDesc.toArray(new PropertyDescriptor[0]);
	}

	public Object getPropertyValue(Object id) {

		if (PROP_ROOTNODE.equals(id)) {
			return getRootNode();
		}
		if (PROP_ONERRORTELE.equals(id)) {
			return getOnErrorTele();
		}
		if (PROP_SOAP.equals(id)) {
			return getSoap();
		}
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return getChildByTypeIdx(Target.class, idx);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {

	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_ROOTNODE.equals(id)) {
			setRootNode((String) value);
		}
		if (PROP_ONERRORTELE.equals(id)) {
			setOnErrorTele((String) value);
		}
		if (PROP_SOAP.equals(id)) {
			setSoap((String) value);
		}

	}
}
