/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

public class SplitterDef extends ContainerDef {
	private String orientation;

	private String style;

	private String prop;

	private String limInf;

	private String limSup;

	private String withImg;

	private String reverseClose;

	private String autoResizeParent;

	private String autoResizableH;

	private String autoResizableW;

	private String tailleCurs;

	private String autoResizeContenu;

	private String overflow;

	private String modeLim;

	/**
	 * ŕ邩
	 * 
	 * @return
	 */
	public boolean isHorizontal() {
		return "h".equalsIgnoreCase(orientation);
	}

	public String getAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(String autoResizebleH) {
		this.autoResizableH = autoResizebleH;
	}

	public String getAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(String autoResizebleW) {
		this.autoResizableW = autoResizebleW;
	}

	public String getAutoResizeParent() {
		return autoResizeParent;
	}

	public void setAutoResizeParent(String autoResizeParent) {
		this.autoResizeParent = autoResizeParent;
	}

	public String getTailleCurs() {
		return tailleCurs;
	}

	public void setTailleCurs(String tailleCurs) {
		this.tailleCurs = tailleCurs;
	}

	public String getLimInf() {
		return limInf;
	}

	public void setLimInf(String limInf) {
		this.limInf = limInf;
	}

	public String getLimSup() {
		return limSup;
	}

	public void setLimSup(String limSup) {
		this.limSup = limSup;
	}

	public String getOrientation() {
		return orientation;
	}

	/**
	 * Xvb^ɂĕݒ肷B
	 * 
	 * @param orientation
	 *            v:ɕB h:ɕB
	 */
	public void setOrientation(String orientation) {
		this.orientation = orientation;
		firePropertyChange("orientation", "", null);
	}

	public String getProp() {
		return prop;
	}

	public void setProp(String prop) {
		this.prop = prop;
	}

	public String getReverseClose() {
		return reverseClose;
	}

	public void setReverseClose(String reverseClose) {
		this.reverseClose = reverseClose;
	}

	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public String getWithImg() {
		return withImg;
	}

	public void setWithImg(String withImg) {
		this.withImg = withImg;
	}

	public String getAutoResizeContenu() {
		return autoResizeContenu;
	}

	public void setAutoResizeContenu(String autoResizeContenu) {
		this.autoResizeContenu = autoResizeContenu;
	}

	public String getModeLim() {
		return modeLim;
	}

	public void setModeLim(String modeLim) {
		this.modeLim = modeLim;
	}

	public String getOverflow() {
		return overflow;
	}

	public void setOverflow(String overflow) {
		this.overflow = overflow;
	}

}
