/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Bind;
import org.maskat.framework.eventdef.Source;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class SourceProperty extends Source implements IPropertySource {

	private static final String PROP_OBJ = "_prop_obj_";

	private static final String PROP_NODE = "_prop_node_";

	private static final String PROP_CHILDNODE = "_prop_childnode_";

	private static final String PROP_IDXREF = "_prop_idxref_";

	private static final String PROP_FROMKEY = "_prop_fromkey_";

	private static final String PROP_TELETYPE = "_prop_teletype_";

	private static final String PROP_SENDBLANKELEMENT = "_prop_sendblankelement_";

	// private Source source;

	private IPropertyDescriptor[] descriptors = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_OBJ, "obj"),
			new MaskatTextPropertyDescriptor(PROP_NODE, "node"),
			new MaskatTextPropertyDescriptor(PROP_CHILDNODE, "childNode"),
			new MaskatTextPropertyDescriptor(PROP_IDXREF, "idxRef"),
			new MaskatTextPropertyDescriptor(PROP_FROMKEY, "fromkey"),
			new MaskatTextPropertyDescriptor(PROP_TELETYPE, "teleType"),
			new MaskatTextPropertyDescriptor(PROP_SENDBLANKELEMENT, "sendBlankElement") };

	public SourceProperty() {
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		List bindsPropDesc = new ArrayList();
		int idx = 0;
		for (Iterator it = getTypedChildren(Bind.class); it != null && it.hasNext(); idx++) {
			it.next();
			bindsPropDesc.add(new PropertyDescriptor(new Integer(idx), "bind"));
		}
		List desc = Arrays.asList(descriptors);
		bindsPropDesc.addAll(desc);

		return (IPropertyDescriptor[]) bindsPropDesc.toArray(new PropertyDescriptor[0]);
	}

	public Object getPropertyValue(Object id) {
		if (PROP_OBJ.equals(id)) {
			return getObj();
		}
		if (PROP_IDXREF.equals(id)) {
			return getIdxRef();
		}
		if (PROP_NODE.equals(id)) {
			return getNode();
		}
		if (PROP_CHILDNODE.equals(id)) {
			return getChildNode();
		}
		if (PROP_FROMKEY.equals(id)) {
			return getFromkey();
		}
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return getChildByTypeIdx(Bind.class, idx);
		}
		if (PROP_TELETYPE.equals(id)) {
			return getTeleType();
		}
		if (PROP_SENDBLANKELEMENT.equals(id)) {
			return getSendBlankElement();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if ("".equals(value)) {
			value = null;
		}
		if (PROP_OBJ.equals(id)) {
			setObj((String) value);
		}
		if (PROP_IDXREF.equals(id)) {
			setIdxRef((String) value);
		}
		if (PROP_NODE.equals(id)) {
			setNode((String) value);
		}
		if (PROP_CHILDNODE.equals(id)) {
			setChildNode((String) value);
		}
		if (PROP_FROMKEY.equals(id)) {
			setFromkey((String) value);
		}
		if (PROP_TELETYPE.equals(id)) {
			setTeleType((String) value);
		}
		if (PROP_SENDBLANKELEMENT.equals(id)) {
			setSendBlankElement((String) value);
		}

	}

}
