/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import java.util.ArrayList;
import java.util.List;

import org.maskat.framework.BasicDef;

public class CustomizeDef extends BasicDef {
	public static class Attribute {
		private String name;

		private String value;

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getValue() {
			return value;
		}

		public void setValue(String value) {
			this.value = value;
		}
	}

	private String prefix;

	private String name;

	private List attributes;

	private String text;

	public String getQName() {
		if (prefix != null && !"".equals(prefix)) {
			return prefix + ":" + name;
		}
		return name;
	}

	public void addAttrib(String name, String value) {
		if (attributes == null)
			attributes = new ArrayList();
		Attribute attrib = new Attribute();
		attrib.setName(name);
		attrib.setValue(value);
		attributes.add(attrib);
	}

	public List getAttributes() {
		return attributes;
	}

	public void setAttributes(List attributes) {
		this.attributes = attributes;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String namespace) {
		this.prefix = namespace;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

}
