/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.maskat.framework.screendef.customize.PluginDefFactory;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MaskatIDEPlugin extends AbstractUIPlugin {
	// The shared instance.
	private static MaskatIDEPlugin plugin;

	// Resource bundle.
	private ResourceBundle resourceBundle;

	public static final String PLUGIN_ID = "org.maskat.ide.gef";

	public void start(BundleContext context) throws Exception {
		super.start(context);
		IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID,
				"customizecomponents");
		IExtension[] extensions = ep.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IExtension ex = extensions[i];
			IConfigurationElement[] configEles = ex.getConfigurationElements();
			for (int j = 0; j < configEles.length; j++) {
				IConfigurationElement element = configEles[j];
				if (element.getName().equals("component")) {
					// gio^
					PluginDefFactory.registerPluginDefs(element, ex.getNamespace());
				}
			}
		}
	}

	/**
	 * The constructor.
	 */
	public MaskatIDEPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle
					.getBundle("org.maskat.ide.view.HelloworldPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static MaskatIDEPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle, or 'key' if not
	 * found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = MaskatIDEPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
