/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

/**
 * Attributes of plugin components are accessed by getAttribute and setAttribute
 * method. Generally the attributes are stored in a map. But to interact with
 * the IDE like an original component, it is necessary that some of the
 * attribute datas are "transfered" to the <code>IComponentDef</code>, like
 * name,left,top and so on, which means they will be stored in the original
 * component object rather than in the plugin component's attribute map.<br>
 * 
 * The instance of this class is hold by <code>IPluginComponentDef</code>,
 * and acts as an adapter between plugin component and non-plugin component.
 * 
 * @author shengshen
 */
public interface IPluginComponentAdapter {

	/**
	 * Get attribute of the plugin component of the specified key .
	 * 
	 * @param key
	 * @return
	 */
	public String getAttribute(String key);

	/**
	 * Set attribute of the plugin component of the specified key .
	 * 
	 * @param key
	 * @return
	 */
	public void setAttribute(String key, String value);
}
