# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


export JAVA_HOME=<%= node['java']['java_home'] %>

export YARN_PID_DIR=<%= node['hadoop']['YARN_PID_DIR'] %>
export YARN_LOG_DIR=<%= node['hadoop']['YARN_LOG_DIR'] %>
<% if node['hadoop']['install_flavor'] == 'apache' then -%>
export YARN_HOME=<%= node['hadoop']['YARN_HOME'] %>

export HADOOP_PREFIX=<%= node['hadoop']['HADOOP_PREFIX'] %>
export HADOOP_COMMON_HOME=<%= node['hadoop']['HADOOP_COMMON_HOME'] %>
export HADOOP_HDFS_HOME=<%= node['hadoop']['HADOOP_HDFS_HOME'] %>
export HADOOP_MAPRED_HOME=<%= node['hadoop']['HADOOP_MAPRED_HOME'] %>
<% elsif node['hadoop']['install_flavor'] == 'cdh' then -%>
export MAPRED_LOG_DIR=<%= node['hadoop']['MAPRED_LOG_DIR'] %>
<% end -%>


# User for YARN daemons
export HADOOP_YARN_USER=${HADOOP_YARN_USER:-yarn}

# resolve links - $0 may be a softlink
<% if node['hadoop']['install_flavor'] == 'cdh' then -%>
export YARN_CONF_DIR="${YARN_CONF_DIR:-$YARN_HOME/conf}"
<% else -%>
export YARN_CONF_DIR="${YARN_CONF_DIR:-$HADOOP_YARN_HOME/conf}"
<% end -%>

# some Java parameters
# export JAVA_HOME=/home/y/libexec/jdk1.6.0/
if [ "$JAVA_HOME" != "" ]; then
  #echo "run java in $JAVA_HOME"
  JAVA_HOME=$JAVA_HOME
fi
  
if [ "$JAVA_HOME" = "" ]; then
  echo "Error: JAVA_HOME is not set."
  exit 1
fi

JAVA=$JAVA_HOME/bin/java
JAVA_HEAP_MAX=-Xmx1000m 

# check envvars which might override default args
if [ "$YARN_HEAPSIZE" != "" ]; then
  #echo "run with heapsize $YARN_HEAPSIZE"
  JAVA_HEAP_MAX="-Xmx""$YARN_HEAPSIZE""m"
  #echo $JAVA_HEAP_MAX
fi

# so that filenames w/ spaces are handled correctly in loops below
IFS=


# default log directory & file
if [ "$YARN_LOG_DIR" = "" ]; then
<% if node['hadoop']['install_flavor'] == 'cdh' then -%>
  YARN_LOG_DIR="$YARN_HOME/logs"
<% else -%>
  YARN_LOG_DIR="$HADOOP_YARN_HOME/logs"
<% end -%>
fi
if [ "$YARN_LOGFILE" = "" ]; then
  YARN_LOGFILE='yarn.log'
fi

# default policy file for service-level authorization
if [ "$YARN_POLICYFILE" = "" ]; then
  YARN_POLICYFILE="hadoop-policy.xml"
fi

# restore ordinary behaviour
unset IFS


YARN_OPTS="$YARN_OPTS -Dhadoop.log.dir=$YARN_LOG_DIR"
YARN_OPTS="$YARN_OPTS -Dyarn.log.dir=$YARN_LOG_DIR"
YARN_OPTS="$YARN_OPTS -Dhadoop.log.file=$YARN_LOGFILE"
YARN_OPTS="$YARN_OPTS -Dyarn.log.file=$YARN_LOGFILE"
YARN_OPTS="$YARN_OPTS -Dyarn.home.dir=$YARN_COMMON_HOME"
YARN_OPTS="$YARN_OPTS -Dyarn.id.str=$YARN_IDENT_STRING"
YARN_OPTS="$YARN_OPTS -Dhadoop.root.logger=${YARN_ROOT_LOGGER:-INFO,console}"
YARN_OPTS="$YARN_OPTS -Dyarn.root.logger=${YARN_ROOT_LOGGER:-INFO,console}"
if [ "x$JAVA_LIBRARY_PATH" != "x" ]; then
  YARN_OPTS="$YARN_OPTS -Djava.library.path=$JAVA_LIBRARY_PATH"
fi  
YARN_OPTS="$YARN_OPTS -Dyarn.policy.file=$YARN_POLICYFILE"

<%
this_file = 'yarn-env.sh'
if defined? node['hadoop']['extra_configs'][this_file] \
  && node['hadoop']['extra_configs'][this_file] != nil then
  node['hadoop']['extra_configs'][this_file].each do |key, value|
-%>
export <%= key %>=<%= value %>
<%
  end
end
-%>

