$LOAD_PATH.push("#{File.dirname(__FILE__)}/../_lib")
#${chef-repo}/_lib/grid.rb
require 'grid'

name 'grid-nm'
description 'Grid Base nagios node'

run_list(
  'role[node_commons]',
  'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[nagios]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

this_cluster = Grid::CLUSTERS[:base]
this_subcluster = Grid::CLUSTERS[:base][:nagioses]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

host_templates = []
hosts = []
hostgroups = []
hostgroup_names = []

Grid::CLUSTERS[:base].each {|key, cluster|
  host_templates.push(
    {
      'name' => cluster[:use_host_object],
      'use' => 'generic-grid-host',
      'register' => '0'
    }
  )

  cluster[:nodes].each {|node|
    hosts.push(
      {
        'host_name' => node,
        'use' => cluster[:use_host_object],
        'address' => "#{node}.#{Grid::DOMAIN}",
      }
    )
  }  

  hostgroups.push( 
    {
      'hostgroup_name' => cluster[:name],
      'alias' => cluster[:alias],
      'members' => cluster[:nodes].join(','),
    }
  )
  hostgroup_names.push(cluster[:name])
}

nagios_objects = {
  'contacts' => [
    {
      'name' => 'generic-grid-contact',
      'service_notification_period' => '24x7',
      'host_notification_period' => '24x7',
      'service_notification_options' => 'w,u,c,r',
      'host_notification_options' => 'd,u,r',
      'service_notification_commands' => 'notify-service-by-email',
      'host_notification_commands' => 'notify-host-by-email',
      'register' => '0'
    },
    {
      'contact_name' => 'alice',
      'use' => 'generic-grid-contact',
      'alias' => 'Alice',
      'email' => 'alice@localhost'
    },
    {
      'contact_name' => 'bob',
      'use' => 'generic-grid-contact',
      'alias' => 'Bob',
      'email' => 'bob@localhost'
    }
  ],
  'contactgroups' => [
    {
      'contactgroup_name' => 'grid-admins',
      'alias' => 'Grid Administrators',
      'members' => 'root'
      #'members' => 'alice,bob'
    }
  ],
  'hosts' => [
    {
      'name' => 'generic-grid-host',
      'use' => 'generic-host',
      'alias' => 'Grid Node',
      'check_command' => 'check-host-alive',
      'max_check_attempts' => '20',
      'notification_interval' => '60',
      'notification_period' => '24x7',
      'notification_options' => 'd,u,r',
      'register' => '0',
    }
  ] + host_templates + hosts,
  'hostgroups' => \
    hostgroups + [
      # all nodes
      {
        'hostgroup_name' => 'grid-servers',
        'alias' => 'GridServers',
        'hostgroup_members' => hostgroup_names.join(',')
      }
    ],
  'services' => [
    # ganglia gmetad monitoring
    {
      'use' => 'generic-check_ganglia_cache-service',
      'host_name' => 'localhost',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-ganglia_heartbeat-service',
      'hostgroup_name' => "#{this_cluster[:gmetads][:name]}",
      'contact_groups' => 'grid-admins',
    },
    # standard monitoring.
    {
      'use' => 'generic-ping-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-ssh-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-ntp-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-load_one-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-load_five-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-load_fifteen-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-part_max_used-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-proc_total-service',
      'hostgroup_name' => 'grid-servers',
      'contact_groups' => 'grid-admins',
    },
    {
      'use' => 'generic-http-service',
      'hostgroup_name' \
        => "#{this_cluster[:gmetads][:name]},#{this_cluster[:nagioses][:name]}",
      'contact_groups' => 'grid-admins',
    },
=begin
    {
      'use' => 'generic-ldap-service',
      'hostgroup_name' => 'grid-nameservice-servers',
      'check_command' => 'check_ldap3!dc=grid,dc=example,dc=com',
      'contact_groups' => 'grid-admins',
    },
=end
  ],
  'servicedependencies' => [
    {
      'host_name' => 'localhost',
      'service_description' => 'Cache for check_ganglia_metric',
      #'dependent_host_name' => '.*',  # NG!
      'dependent_hostgroup_name' => 'grid-servers',
      'dependent_service_description' => '.* via Ganglia$',
      'execution_failure_criteria' => 'c,p'
    }
  ]
}

default_attributes(
  'nagios' => {
    'cluster_name' => 'grid-base',
    'objects' => nagios_objects,
    'web' => {
      'Allow' => [
        "from .#{Grid::DOMAIN}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => Grid::REALM,
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    },
    'check_external_commands' => '1',
    'use_regexp_matching' => '1',
    'authorized_for_system_information' => '*',
    'authorized_for_configuration_information' => '*',
    'authorized_for_system_commands' => '*',
    'authorized_for_all_services' => '*',
    'authorized_for_all_hosts' => '*',
    'authorized_for_all_service_commands' => '*',
    'authorized_for_all_host_commands' => '*',
    'check_ganglia_metric' => {
      'enabled' => true,
      'gmetad_host' => "#{this_cluster[:gmetads][:service_hostname]}.#{Grid::DOMAIN}"
    },
  }
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    'static' => {
      ## static multi-cast
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
