/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.DesktopAssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.asset.plugins.AndroidLocator;
import com.jme3.asset.plugins.ClasspathLocator;
import com.jme3.audio.plugins.AndroidAudioLoader;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.font.plugins.BitmapFontLoader;
import com.jme3.material.plugins.J3MLoader;
import com.jme3.scene.plugins.MTLLoader;
import com.jme3.scene.plugins.OBJLoader;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.scene.plugins.ogre.MeshLoader;
import com.jme3.scene.plugins.ogre.SceneLoader;
import com.jme3.scene.plugins.ogre.SkeletonLoader;
import com.jme3.shader.plugins.GLSLLoader;
import com.jme3.texture.Texture;
import com.jme3.texture.plugins.AndroidImageLoader;
import com.jme3.texture.plugins.DDSLoader;
import com.jme3.texture.plugins.HDRLoader;
import com.jme3.texture.plugins.PFMLoader;
import com.jme3.texture.plugins.TGALoader;
import java.net.URL;
import java.util.logging.Logger;

public class AndroidAssetManager
extends DesktopAssetManager {
    private static final Logger logger = Logger.getLogger(AndroidAssetManager.class.getName());

    public AndroidAssetManager() {
        this(null);
    }

    @Deprecated
    public AndroidAssetManager(boolean loadDefaults) {
        this(null);
    }

    public AndroidAssetManager(URL configFile) {
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
        this.registerLocator("", AndroidLocator.class);
        this.registerLocator("", ClasspathLocator.class);
        this.registerLoader(AndroidImageLoader.class, "jpg", "bmp", "gif", "png", "jpeg");
        this.registerLoader(AndroidAudioLoader.class, "ogg", "mp3");
        this.registerLoader(J3MLoader.class, "j3m");
        this.registerLoader(J3MLoader.class, "j3md");
        this.registerLoader(BitmapFontLoader.class, "fnt");
        this.registerLoader(DDSLoader.class, "dds");
        this.registerLoader(PFMLoader.class, "pfm");
        this.registerLoader(HDRLoader.class, "hdr");
        this.registerLoader(TGALoader.class, "tga");
        this.registerLoader(BinaryImporter.class, "j3o");
        this.registerLoader(OBJLoader.class, "obj");
        this.registerLoader(MTLLoader.class, "mtl");
        this.registerLoader(MeshLoader.class, "meshxml", "mesh.xml");
        this.registerLoader(SkeletonLoader.class, "skeletonxml", "skeleton.xml");
        this.registerLoader(MaterialLoader.class, "material");
        this.registerLoader(SceneLoader.class, "scene");
        this.registerLoader(GLSLLoader.class, "vert", "frag", "glsl", "glsllib");
        logger.info("AndroidAssetManager created.");
    }

    @Override
    public Texture loadTexture(TextureKey key) {
        Texture tex = this.loadAsset(key);
        tex.setMagFilter(Texture.MagFilter.Nearest);
        tex.setAnisotropicFilter(0);
        if (tex.getMinFilter().usesMipMapLevels()) {
            tex.setMinFilter(Texture.MinFilter.NearestNearestMipMap);
        } else {
            tex.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
        return tex;
    }
}

