/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Server;
import com.jme3.network.connection.TCPConnection;
import com.jme3.network.connection.UDPConnection;
import com.jme3.system.JmeSystem;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionRunnable
implements Runnable {
    protected Logger log = Logger.getLogger(Server.class.getName());
    private TCPConnection tcp;
    private UDPConnection udp;
    private int delay = 2;
    private boolean keepAlive = true;
    private boolean alive = true;

    public ConnectionRunnable(TCPConnection tcp, UDPConnection udp, int delay) {
        this.tcp = tcp;
        this.udp = udp;
        this.delay = delay;
    }

    public ConnectionRunnable(TCPConnection tcp, UDPConnection udp) {
        this.tcp = tcp;
        this.udp = udp;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isRunning() {
        return this.alive;
    }

    public void run() {
        if (!JmeSystem.isLowPermissions()) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread thread, Throwable thrown) {
                    ConnectionRunnable.this.log.log(Level.SEVERE, "Uncaught exception thrown in " + thread.toString(), thrown);
                }
            });
        }
        while (this.keepAlive) {
            this.tcp.run();
            this.udp.run();
            if (this.delay > 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Thread.yield();
        }
        try {
            this.tcp.cleanup();
            this.udp.cleanup();
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "[???][???] Could not clean up the connection.", e);
            return;
        }
        this.alive = false;
        this.log.log(Level.FINE, "[???][???] Cleaned up TCP/UDP.");
    }
}

