/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.Connection;
import com.jme3.network.message.DiscoverHostMessage;
import com.jme3.network.message.Message;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.logging.Level;

public class UDPConnection
extends Connection {
    protected DatagramChannel datagramChannel;
    protected ByteBuffer writeBuffer;
    protected ByteBuffer readBuffer;
    protected SocketAddress target = null;

    public UDPConnection(String label) {
        this.label = label;
        this.readBuffer = ByteBuffer.allocateDirect(8192);
        this.writeBuffer = ByteBuffer.allocateDirect(8192);
    }

    public void connect(SocketAddress address) throws IOException {
        this.datagramChannel = this.selector.provider().openDatagramChannel();
        this.datagramChannel.socket().bind(null);
        this.datagramChannel.socket().connect(address);
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.register(this.selector, 1);
        this.log.log(Level.INFO, "[{1}][UDP] Set target to {0}", new Object[]{address, this.label});
        this.target = address;
    }

    public void bind(SocketAddress address) throws IOException {
        this.datagramChannel = this.selector.provider().openDatagramChannel();
        this.datagramChannel.socket().bind(address);
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.register(this.selector, 1);
        this.log.log(Level.INFO, "[{1}][UDP] Bound to {0}", new Object[]{address, this.label});
    }

    public void connect(SelectableChannel channel) throws IOException {
    }

    public void accept(SelectableChannel channel) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SelectableChannel channel) throws IOException {
        DatagramChannel socketChannel = (DatagramChannel)channel;
        InetSocketAddress address = (InetSocketAddress)this.datagramChannel.receive(this.readBuffer);
        if (address == null) {
            socketChannel.close();
            return;
        }
        String reason = this.shouldFilterConnector(address);
        if (reason != null) {
            this.log.log(Level.INFO, "[Server][UDP] Client with address {0} got filtered with reason: {1}", new Object[]{address, reason});
            socketChannel.close();
            return;
        }
        SelectionKey key = socketChannel.keyFor(this.selector);
        if ((key.attachment() == null || ((Client)key.attachment()).getDatagramReceiver() != address) && this.target == null) {
            Client client = new Client(true);
            client.setDatagramReceiver(address);
            client.setUDPConnection(this);
            client.setDatagramChannel(socketChannel);
            ArrayList arrayList = this.connections;
            synchronized (arrayList) {
                this.connections.add(client);
            }
            key.attach(client);
        }
        this.readBuffer.flip();
        Object object = Serializer.readClassAndObject(this.readBuffer);
        this.log.log(Level.FINE, "[{0}][UDP] Read full object: {1}", new Object[]{this.label, object});
        if (object instanceof Message) {
            Message message = (Message)object;
            if (message instanceof DiscoverHostMessage) {
                ArrayList arrayList = this.connections;
                synchronized (arrayList) {
                    this.connections.remove((Client)key.attachment());
                }
                this.log.log(Level.FINE, "[{0}][UDP] Responded to a discover host message by {1}.", new Object[]{this.label, address});
                this.send(address, message);
                return;
            }
            Object attachment = socketChannel.keyFor(this.selector).attachment();
            if (attachment instanceof Client) {
                message.setClient((Client)attachment);
            }
            message.setConnection(this);
            this.fireMessageReceived(message);
        } else {
            this.fireObjectReceived(object);
        }
        this.readBuffer.clear();
    }

    protected synchronized void send(SocketAddress dest, Object object) {
        try {
            Serializer.writeClassAndObject(this.writeBuffer, object);
            this.writeBuffer.flip();
            if (dest == null) {
                throw new NullPointerException();
            }
            int bytes = this.datagramChannel.send(this.writeBuffer, dest);
            if (object instanceof Message) {
                this.fireMessageSent((Message)object);
            } else {
                this.fireObjectSent(object);
            }
            this.log.log(Level.FINE, "[{0}][UDP] Wrote {1} bytes to {2}.", new Object[]{this.label, bytes, dest});
            this.writeBuffer.clear();
        }
        catch (ClosedChannelException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObject(Object object) throws IOException {
        if (this.target == null) {
            ArrayList arrayList = this.connections;
            synchronized (arrayList) {
                for (Client connector : this.connections) {
                    this.send(connector.getDatagramReceiver(), object);
                }
            }
        } else {
            this.send(this.target, object);
        }
    }

    public void sendObject(Client client, Object object) throws IOException {
        if (object instanceof Message) {
            ((Message)object).setClient(client);
        }
        this.send(client.getDatagramReceiver(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws IOException {
        this.datagramChannel.close();
        if (this.target == null) {
            ArrayList arrayList = this.connections;
            synchronized (arrayList) {
                this.connections.clear();
            }
        }
    }

    public void write(SelectableChannel channel) throws IOException {
    }
}

