/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.streaming;

import com.jme3.network.connection.Client;
import com.jme3.network.events.MessageAdapter;
import com.jme3.network.message.Message;
import com.jme3.network.message.StreamDataMessage;
import com.jme3.network.message.StreamMessage;
import com.jme3.network.streaming.Stream;
import com.jme3.network.streaming.StreamListener;
import com.jme3.network.streaming.StreamingService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientStreamingService
extends MessageAdapter {
    private static Logger log = Logger.getLogger(StreamingService.class.getName());
    protected ArrayList<StreamListener> streamListeners;
    protected ArrayList<Stream> streams;
    private Client client;

    public ClientStreamingService(Client client) {
        this.client = client;
        this.streams = new ArrayList();
        this.streamListeners = new ArrayList();
        client.addMessageListener(this, StreamDataMessage.class, StreamMessage.class);
    }

    public void addStreamListener(StreamListener listener) {
        this.streamListeners.add(listener);
    }

    public void removeStreamListener(StreamListener listener) {
        this.streamListeners.remove(listener);
    }

    public void messageReceived(Message message) {
        block8: {
            block6: {
                Stream stream;
                StreamMessage msg;
                block7: {
                    if (!(message instanceof StreamMessage) || message instanceof StreamDataMessage) break block6;
                    msg = (StreamMessage)message;
                    stream = this.getStream(msg.getStreamID());
                    if (stream == null) break block7;
                    for (StreamListener listener : stream.getDataListeners()) {
                        listener.streamCompleted(msg);
                    }
                    break block8;
                }
                stream = new Stream();
                stream.setMessage(msg);
                boolean accept = this.fireStreamOffered(stream, msg);
                this.streams.add(stream);
                if (!accept) break block8;
                try {
                    this.client.send(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block8;
            }
            if (message instanceof StreamDataMessage) {
                StreamDataMessage dataMessage = (StreamDataMessage)message;
                Stream stream = this.getStream(dataMessage.getStreamID());
                if (stream == null) {
                    log.log(Level.WARNING, "[StreamClient][TCP] We've received a data message even though we didn't register to the stream.");
                    return;
                }
                for (StreamListener listener : stream.getDataListeners()) {
                    listener.streamDataReceived(dataMessage);
                }
            }
        }
    }

    private Stream getStream(short id) {
        for (Stream stream : this.streams) {
            if (stream.getMessage().getStreamID() != id) continue;
            return stream;
        }
        return null;
    }

    private boolean fireStreamOffered(Stream stream, StreamMessage message) {
        boolean accept = false;
        for (StreamListener listener : this.streamListeners) {
            if (!listener.streamOffered(message)) continue;
            accept = true;
            stream.addDataListener(listener);
        }
        return accept;
    }
}

