/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.ssao;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.ArrayList;

public class SSAOFilter
extends Filter {
    private Filter.Pass normalPass;
    private Vector3f frustumCorner;
    private Vector2f frustumNearFar;
    private Vector2f[] samples = new Vector2f[]{new Vector2f(1.0f, 0.0f), new Vector2f(-1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, -1.0f)};
    private float sampleRadius = 5.1f;
    private float intensity = 1.5f;
    private float scale = 0.2f;
    private float bias = 0.1f;
    private boolean useOnlyAo = false;
    private boolean useAo = true;
    private Material ssaoMat;
    private Filter.Pass ssaoPass;
    private float downSampleFactor = 1.0f;

    public SSAOFilter() {
        super("SSAOFilter");
    }

    public SSAOFilter(float sampleRadius, float intensity, float scale, float bias) {
        this();
        this.sampleRadius = sampleRadius;
        this.intensity = intensity;
        this.scale = scale;
        this.bias = bias;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void postQueue(RenderManager renderManager, ViewPort viewPort) {
        Renderer r = renderManager.getRenderer();
        r.setFrameBuffer(this.normalPass.getRenderFrameBuffer());
        renderManager.getRenderer().clearBuffers(true, true, true);
        renderManager.setForcedTechnique("PreNormalPass");
        renderManager.renderViewPortQueues(viewPort, false);
        renderManager.setForcedTechnique(null);
        renderManager.getRenderer().setFrameBuffer(viewPort.getOutputFrameBuffer());
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        int screenWidth = w;
        int screenHeight = h;
        this.postRenderPasses = new ArrayList();
        this.normalPass = new Filter.Pass();
        this.normalPass.init(renderManager.getRenderer(), (int)((float)screenWidth / this.downSampleFactor), (int)((float)screenHeight / this.downSampleFactor), Image.Format.RGBA8, Image.Format.Depth);
        this.frustumNearFar = new Vector2f();
        float farY = vp.getCamera().getFrustumTop() / vp.getCamera().getFrustumNear() * vp.getCamera().getFrustumFar();
        float farX = farY * ((float)screenWidth / (float)screenHeight);
        this.frustumCorner = new Vector3f(farX, farY, vp.getCamera().getFrustumFar());
        this.frustumNearFar.x = vp.getCamera().getFrustumNear();
        this.frustumNearFar.y = vp.getCamera().getFrustumFar();
        this.ssaoMat = new Material(manager, "Common/MatDefs/SSAO/ssao.j3md");
        this.ssaoMat.setTexture("Normals", this.normalPass.getRenderedTexture());
        Texture random = manager.loadTexture("Common/MatDefs/SSAO/Textures/random.png");
        random.setWrap(Texture.WrapMode.Repeat);
        this.ssaoMat.setTexture("RandomMap", random);
        this.ssaoPass = new Filter.Pass(){

            public boolean requiresDepthAsTexture() {
                return true;
            }
        };
        this.ssaoPass.init(renderManager.getRenderer(), (int)((float)screenWidth / this.downSampleFactor), (int)((float)screenHeight / this.downSampleFactor), Image.Format.RGBA8, Image.Format.Depth, 1, this.ssaoMat);
        this.ssaoPass.getRenderedTexture().setMinFilter(Texture.MinFilter.Trilinear);
        this.ssaoPass.getRenderedTexture().setMagFilter(Texture.MagFilter.Bilinear);
        this.postRenderPasses.add(this.ssaoPass);
        this.material = new Material(manager, "Common/MatDefs/SSAO/ssaoBlur.j3md");
        this.material.setTexture("SSAOMap", this.ssaoPass.getRenderedTexture());
        this.ssaoMat.setVector3("FrustumCorner", this.frustumCorner);
        this.ssaoMat.setFloat("SampleRadius", this.sampleRadius);
        this.ssaoMat.setFloat("Intensity", this.intensity);
        this.ssaoMat.setFloat("Scale", this.scale);
        this.ssaoMat.setFloat("Bias", this.bias);
        this.material.setBoolean("UseAo", this.useAo);
        this.material.setBoolean("UseOnlyAo", this.useOnlyAo);
        this.ssaoMat.setVector2("FrustumNearFar", this.frustumNearFar);
        this.material.setVector2("FrustumNearFar", this.frustumNearFar);
        this.ssaoMat.setParam("Samples", VarType.Vector2Array, this.samples);
        float xScale = 1.0f / (float)w;
        float yScale = 1.0f / (float)h;
        float blurScale = 2.0f;
        this.material.setFloat("XScale", blurScale * xScale);
        this.material.setFloat("YScale", blurScale * yScale);
    }

    public float getBias() {
        return this.bias;
    }

    public void setBias(float bias) {
        this.bias = bias;
        if (this.ssaoMat != null) {
            this.ssaoMat.setFloat("Bias", bias);
        }
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        if (this.ssaoMat != null) {
            this.ssaoMat.setFloat("Intensity", intensity);
        }
    }

    public float getSampleRadius() {
        return this.sampleRadius;
    }

    public void setSampleRadius(float sampleRadius) {
        this.sampleRadius = sampleRadius;
        if (this.ssaoMat != null) {
            this.ssaoMat.setFloat("SampleRadius", sampleRadius);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        if (this.ssaoMat != null) {
            this.ssaoMat.setFloat("Scale", scale);
        }
    }

    public boolean isUseAo() {
        return this.useAo;
    }

    public void setUseAo(boolean useAo) {
        this.useAo = useAo;
        if (this.material != null) {
            this.material.setBoolean("UseAo", useAo);
        }
    }

    public boolean isUseOnlyAo() {
        return this.useOnlyAo;
    }

    public void setUseOnlyAo(boolean useOnlyAo) {
        this.useOnlyAo = useOnlyAo;
        if (this.material != null) {
            this.material.setBoolean("UseOnlyAo", useOnlyAo);
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.sampleRadius, "sampleRadius", 5.1f);
        oc.write(this.intensity, "intensity", 1.5f);
        oc.write(this.scale, "scale", 0.2f);
        oc.write(this.bias, "bias", 0.1f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.sampleRadius = ic.readFloat("sampleRadius", 5.1f);
        this.intensity = ic.readFloat("intensity", 1.5f);
        this.scale = ic.readFloat("scale", 0.2f);
        this.bias = ic.readFloat("bias", 0.1f);
    }
}

