/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.scene.Geometry;
import com.jme3.scene.GeometryBatch;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchedGeometry
extends Spatial {
    private GeometryBatch batch;
    protected int startIndex;
    protected int vertexCount;
    protected int triangleCount;
    protected Transform prevLocalTransform = new Transform();
    protected Matrix4f cachedOffsetMat = new Matrix4f();
    protected Matrix4f tmpMat = new Matrix4f();

    protected BatchedGeometry(GeometryBatch batch, Geometry geom) {
        this.batch = batch;
        this.vertexCount = geom.getVertexCount();
        this.triangleCount = geom.getTriangleCount();
        this.name = geom.getName();
    }

    @Override
    protected void updateWorldTransforms() {
        if (this.batch == null) {
            this.worldTransform.set(this.localTransform);
            this.refreshFlags &= 0xFFFFFFFE;
        } else {
            assert ((this.batch.refreshFlags & 1) == 0);
            this.worldTransform.set(this.localTransform);
            this.worldTransform.combineWithParent(this.batch.worldTransform);
            this.computeOffsetTransform();
            this.batch.updateSubBatch(this);
            this.prevLocalTransform.set(this.localTransform);
            this.refreshFlags &= 0xFFFFFFFE;
        }
    }

    @Override
    public Node getParent() {
        return this.batch.getParent();
    }

    public void computeOffsetTransform() {
        this.cachedOffsetMat.loadIdentity();
        this.cachedOffsetMat.setRotationQuaternion(this.prevLocalTransform.getRotation());
        this.cachedOffsetMat.setTranslation(this.prevLocalTransform.getTranslation());
        TempVars vars = TempVars.get();
        Matrix4f scaleMat = vars.tempMat4;
        scaleMat.loadIdentity();
        scaleMat.scale(this.prevLocalTransform.getScale());
        this.cachedOffsetMat.multLocal(scaleMat);
        this.cachedOffsetMat.invertLocal();
        this.tmpMat.loadIdentity();
        this.tmpMat.setRotationQuaternion(this.localTransform.getRotation());
        this.tmpMat.setTranslation(this.localTransform.getTranslation());
        scaleMat.loadIdentity();
        scaleMat.scale(this.localTransform.getScale());
        this.tmpMat.multLocal(scaleMat);
        this.tmpMat.mult(this.cachedOffsetMat, this.cachedOffsetMat);
        vars.release();
    }

    @Override
    public void updateModelBound() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setModelBound(BoundingVolume modelBound) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public int getTriangleCount() {
        return this.triangleCount;
    }

    @Override
    public Spatial deepClone() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void depthFirstTraversal(SceneGraphVisitor visitor) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    protected void breadthFirstTraversal(SceneGraphVisitor visitor, Queue<Spatial> queue) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) throws UnsupportedCollisionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

