/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.ArmatureModifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.ogre.AnimData;
import java.util.ArrayList;
import java.util.List;

class ObjectAnimationModifier
extends ArmatureModifier {
    public ObjectAnimationModifier(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (pIpo.isNotNull()) {
            String objectAnimationName = null;
            List<FileBlockHeader> actionBlocks = dataRepository.getFileBlocks(1094909952);
            for (FileBlockHeader actionBlock : actionBlocks) {
                Pointer pChannelIpo;
                Structure action = actionBlock.getStructure(dataRepository);
                List<Structure> actionChannels = ((Structure)action.getFieldValue("chanbase")).evaluateListBase(dataRepository);
                if (actionChannels.size() != 1 || !(pChannelIpo = (Pointer)actionChannels.get(0).getFieldValue("ipo")).equals(pIpo)) continue;
                objectAnimationName = action.getName();
                break;
            }
            String objectName = objectStructure.getName();
            if (objectAnimationName == null) {
                objectAnimationName = objectName;
            }
            IpoHelper ipoHelper = (IpoHelper)dataRepository.getHelper(IpoHelper.class);
            Structure ipoStructure = pIpo.fetchData(dataRepository.getInputStream()).get(0);
            Ipo ipo = ipoHelper.createIpo(ipoStructure, dataRepository);
            int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, objectAnimationName);
            if (animationFrames == null) {
                animationFrames = new int[]{1, ipo.getLastFrame()};
            }
            int fps = dataRepository.getBlenderKey().getFps();
            float start = (float)animationFrames[0] / (float)fps;
            float stop = (float)animationFrames[1] / (float)fps;
            BoneTrack[] tracks = new BoneTrack[]{ipo.calculateTrack(0, animationFrames[0], animationFrames[1], fps)};
            BoneAnimation boneAnimation = new BoneAnimation(objectAnimationName, stop - start);
            boneAnimation.setTracks(tracks);
            ArrayList<Animation> animations = new ArrayList<Animation>(1);
            animations.add(boneAnimation);
            ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
            Transform t = objectHelper.getTransformation(objectStructure, dataRepository);
            Bone bone = new Bone(null);
            bone.setBindTransforms(t.getTranslation(), t.getRotation(), t.getScale());
            this.jmeModifierRepresentation = new AnimData(new Skeleton(new Bone[]{bone}), animations);
            this.additionalData = objectStructure.getOldMemoryAddress();
        }
    }

    public String getType() {
        return "ObjectAnimationModifierData";
    }
}

