/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.blockparser;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement {
    private int lineNumber;
    private String line;
    private List<Statement> contents = new ArrayList<Statement>();

    Statement(int lineNumber, String line) {
        this.lineNumber = lineNumber;
        this.line = line;
    }

    void addStatement(Statement statement) {
        this.contents.add(statement);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public List<Statement> getContents() {
        return this.contents;
    }

    private String getIndent(int indent) {
        return "                               ".substring(0, indent);
    }

    private String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndent(indent));
        sb.append(this.line);
        if (this.contents != null) {
            sb.append(" {\n");
            for (Statement statement : this.contents) {
                sb.append(statement.toString(indent + 4));
                sb.append("\n");
            }
            sb.append(this.getIndent(indent));
            sb.append("}");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

