/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.video;

import com.jme3.app.SimpleApplication;
import com.jme3.audio.AudioNode;
import com.jme3.system.AppSettings;
import com.jme3.texture.Image;
import com.jme3.ui.Picture;
import com.jme3.video.Clock;
import com.jme3.video.VFrame;
import com.jme3.video.VQueue;
import com.jme3.video.plugins.jheora.AVThread;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@Deprecated
public class TestVideoPlayer
extends SimpleApplication {
    private Picture picture;
    private AVThread decoder;
    private Thread videoThread;
    private VQueue videoQueue;
    private long lastFrameTime = 0L;
    private Clock masterClock;
    private AudioNode source;
    private float waitTime = 0.0f;
    private VFrame frameToDraw = null;

    public static void main(String[] args) {
        TestVideoPlayer app = new TestVideoPlayer();
        AppSettings settings = new AppSettings(true);
        settings.setFrameRate(60);
        app.setSettings(settings);
        app.start();
    }

    private void createVideo() {
        try {
            InputStream fis = new URL("http://mirrorblender.top-ix.org/peach/bigbuckbunny_movies/big_buck_bunny_480p_stereo.ogg").openStream();
            this.videoQueue = new VQueue(5);
            this.decoder = new AVThread(fis, this.videoQueue);
            this.videoThread = new Thread((Runnable)this.decoder, "Jheora Video Decoder");
            this.videoThread.setDaemon(true);
            this.videoThread.start();
            this.masterClock = this.decoder.getMasterClock();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void simpleInitApp() {
        this.picture = new Picture("VideoPicture", true);
        this.picture.setPosition(0.0f, 0.0f);
        this.picture.setWidth(this.settings.getWidth());
        this.picture.setHeight(this.settings.getHeight());
        this.picture.setImage(this.assetManager, "Interface/Logo/Monkey.jpg", false);
        this.rootNode.attachChild(this.picture);
        this.createVideo();
    }

    private void drawFrame(VFrame frame) {
        Image image = frame.getImage();
        frame.setImage(image);
        this.picture.setTexture(this.assetManager, frame, false);
        this.renderer.setTexture(0, frame);
        this.videoQueue.returnFrame(frame);
        this.lastFrameTime = frame.getTime();
    }

    private void waitNanos(long time) {
        long millis = time / 1000000L;
        int nanos = (int)(time - millis * 1000000L);
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException ex) {
            this.stop();
            return;
        }
    }

    public void simpleUpdate(float tpf) {
        if (this.source == null) {
            if (this.decoder.getAudioStream() != null) {
                this.source = new AudioNode(this.audioRenderer, this.decoder.getAudioStream(), null);
                this.source.setPositional(false);
                this.source.setReverbEnabled(false);
                this.audioRenderer.playSource(this.source);
            } else {
                return;
            }
        }
        if (this.waitTime > 0.0f) {
            this.waitTime -= tpf;
            if (this.waitTime > 0.0f) {
                return;
            }
            this.waitTime = 0.0f;
            this.drawFrame(this.frameToDraw);
            this.frameToDraw = null;
        } else {
            long syncThresh;
            VFrame frame;
            try {
                frame = (VFrame)this.videoQueue.take();
            }
            catch (InterruptedException ex) {
                this.stop();
                return;
            }
            if (frame.getTime() < this.lastFrameTime) {
                this.videoQueue.returnFrame(frame);
                return;
            }
            if (frame.getTime() == -2L) {
                System.out.println("End of stream");
                this.stop();
                return;
            }
            long AV_SYNC_THRESHOLD = 1000000L;
            long delay = frame.getTime() - this.lastFrameTime;
            long diff = frame.getTime() - this.masterClock.getTime();
            long l = syncThresh = delay > AV_SYNC_THRESHOLD ? delay : AV_SYNC_THRESHOLD;
            if (Math.abs(diff) < 1000000000L) {
                if (diff <= -syncThresh) {
                    delay = 0L;
                } else if (diff >= syncThresh) {
                    delay = 2L * delay;
                }
            }
            System.out.println("M: " + this.decoder.getSystemClock().getTimeSeconds() + ", V: " + this.decoder.getVideoClock().getTimeSeconds() + ", A: " + this.decoder.getAudioClock().getTimeSeconds());
            if (delay > 0L) {
                this.waitNanos(delay);
                this.drawFrame(frame);
            } else {
                this.videoQueue.returnFrame(frame);
                this.lastFrameTime = frame.getTime();
            }
        }
    }
}

