/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.newt.util.MainThread;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;
import jogamp.newt.DefaultEDTUtil;
import jogamp.newt.event.NEWTEventTask;

public abstract class DisplayImpl
extends Display {
    public static final boolean DEBUG_TEST_EDT_MAINTHREAD = Debug.isPropertyDefined("newt.test.EDTMainThread", true);
    private static int serialno = 1;
    public static final String nilString = "nil";
    private Object eventsLock = new Object();
    private ArrayList events = new ArrayList();
    DispatchMessagesRunnable dispatchMessagesRunnable = new DispatchMessagesRunnable();
    protected EDTUtil edtUtil = null;
    protected int id;
    protected String name;
    protected String type;
    protected String fqname;
    protected int hashCode;
    protected int refCount;
    protected boolean destroyWhenUnused;
    protected AbstractGraphicsDevice aDevice;

    private static Class getDisplayClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "Display");
        if (null == clazz) {
            if ("EGL".equals(string)) {
                clazz = Class.forName("jogamp.newt.opengl.kd.KDDisplay");
            } else if ("Windows".equals(string)) {
                clazz = Class.forName("jogamp.newt.windows.WindowsDisplay");
            } else if ("MacOSX".equals(string)) {
                clazz = Class.forName("jogamp.newt.macosx.MacDisplay");
            } else if ("X11".equals(string)) {
                clazz = Class.forName("jogamp.newt.x11.X11Display");
            } else if ("AWT".equals(string)) {
                clazz = Class.forName("jogamp.newt.awt.AWTDisplay");
            } else {
                throw new RuntimeException("Unknown display type \"" + string + "\"");
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display create(String string, String string2, long l, boolean bl) {
        try {
            Class clazz = DisplayImpl.getDisplayClass(string);
            DisplayImpl displayImpl = (DisplayImpl)clazz.newInstance();
            string2 = displayImpl.validateDisplayName(string2, l);
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                Display display;
                if (bl && null != (display = Display.getLastDisplayOf(string, string2, -1))) {
                    if (DEBUG) {
                        System.err.println("Display.create() REUSE: " + display + " " + DisplayImpl.getThreadName());
                    }
                    return display;
                }
                displayImpl.name = string2;
                displayImpl.type = string;
                displayImpl.destroyWhenUnused = false;
                displayImpl.refCount = 0;
                displayImpl.id = serialno++;
                displayImpl.fqname = DisplayImpl.getFQName(displayImpl.type, displayImpl.name, displayImpl.id);
                displayImpl.hashCode = displayImpl.fqname.hashCode();
                displayList.add(displayImpl);
            }
            displayImpl.createEDTUtil();
            if (DEBUG) {
                System.err.println("Display.create() NEW: " + displayImpl + " " + DisplayImpl.getThreadName());
            }
            return displayImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        if (null == this.aDevice) {
            if (DEBUG) {
                System.err.println("Display.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            final DisplayImpl displayImpl = this;
            try {
                this.runOnEDTIfAvail(true, new Runnable(){

                    @Override
                    public void run() {
                        displayImpl.createNativeImpl();
                    }
                });
            }
            catch (Throwable throwable) {
                throw new NativeWindowException(throwable);
            }
            if (null == this.aDevice) {
                throw new NativeWindowException("Display.createNative() failed to instanciate an AbstractGraphicsDevice");
            }
            if (DEBUG) {
                System.err.println("Display.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            ArrayList arrayList = displayList;
            synchronized (arrayList) {
                ++displaysActive;
            }
        }
    }

    protected boolean shallRunOnEDT() {
        return true;
    }

    protected void createEDTUtil() {
        if (NewtFactory.useEDT()) {
            if (!DEBUG_TEST_EDT_MAINTHREAD) {
                Thread thread = Thread.currentThread();
                this.edtUtil = new DefaultEDTUtil(thread.getThreadGroup(), "Display-" + this.getFQName(), this.dispatchMessagesRunnable);
            } else {
                MainThread.addPumpMessage(this, this.dispatchMessagesRunnable);
                this.edtUtil = MainThread.getSingleton();
            }
            if (DEBUG) {
                System.err.println("Display.createNative(" + this.getFQName() + ") Create EDTUtil: " + this.edtUtil.getClass().getName());
            }
        }
    }

    @Override
    public final EDTUtil getEDTUtil() {
        return this.edtUtil;
    }

    private void stopEDT(Runnable runnable) {
        if (this.shallRunOnEDT() && null != this.edtUtil) {
            this.edtUtil.invokeStop(runnable);
        } else {
            runnable.run();
        }
    }

    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        if (this.shallRunOnEDT() && null != this.edtUtil) {
            this.edtUtil.invoke(bl, runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean validateEDT() {
        if (0 == this.refCount && null == this.aDevice && null != this.edtUtil && this.edtUtil.isRunning()) {
            this.stopEDT(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.edtUtil.waitUntilStopped();
            this.edtUtil.reset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") BEGIN");
        }
        ArrayList arrayList = displayList;
        synchronized (arrayList) {
            displayList.remove(this);
            if (0 < displaysActive) {
                --displaysActive;
            }
        }
        if (DEBUG) {
            System.err.println("Display.destroy(): " + this + " " + DisplayImpl.getThreadName());
        }
        arrayList = this.aDevice;
        DisplayImpl displayImpl = this;
        this.stopEDT(new Runnable((AbstractGraphicsDevice)arrayList, displayImpl){
            final /* synthetic */ AbstractGraphicsDevice val$f_aDevice;
            final /* synthetic */ DisplayImpl val$f_dpy;
            {
                this.val$f_aDevice = abstractGraphicsDevice;
                this.val$f_dpy = displayImpl2;
            }

            @Override
            public void run() {
                if (null != this.val$f_aDevice) {
                    this.val$f_dpy.closeNativeImpl();
                }
            }
        });
        if (null != this.edtUtil) {
            if (DEBUG_TEST_EDT_MAINTHREAD) {
                MainThread.removePumpMessage(this);
            }
            this.edtUtil.waitUntilStopped();
            this.edtUtil.reset();
        }
        this.aDevice = null;
        this.refCount = 0;
        if (DEBUG) {
            DisplayImpl.dumpDisplayList("Display.destroy(" + this.getFQName() + ") END");
        }
    }

    @Override
    public final synchronized int addReference() {
        if (DEBUG) {
            System.err.println("Display.addReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aDevice) {
            throw new NativeWindowException("Display.addReference() (refCount " + this.refCount + ") null AbstractGraphicsDevice");
        }
        return this.refCount++;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            System.err.println("Display.removeReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1));
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    public String validateDisplayName(String string, long l) {
        if (null == string && 0L != l) {
            string = "wrapping-" + DisplayImpl.toHexString(l);
        }
        return null == string ? nilString : string;
    }

    private static final String getFQName(String string, String string2, int n) {
        if (null == string) {
            string = nilString;
        }
        if (null == string2) {
            string2 = nilString;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("_");
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(n);
        return stringBuffer.toString().intern();
    }

    @Override
    public final long getHandle() {
        if (null != this.aDevice) {
            return this.aDevice.getHandle();
        }
        return 0L;
    }

    @Override
    public final AbstractGraphicsDevice getGraphicsDevice() {
        return this.aDevice;
    }

    @Override
    public final boolean isNativeValid() {
        return null != this.aDevice;
    }

    @Override
    public boolean isEDTRunning() {
        if (null != this.edtUtil) {
            return this.edtUtil.isRunning();
        }
        return false;
    }

    public String toString() {
        return "NEWT-Display[" + this.getFQName() + ", refCount " + this.refCount + ", hasEDT " + (null != this.edtUtil) + ", edtRunning " + this.isEDTRunning() + ", " + this.aDevice + "]";
    }

    protected abstract void dispatchMessagesNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchMessages() {
        if (0 == this.refCount) {
            return;
        }
        if (null == this.getGraphicsDevice()) {
            return;
        }
        ArrayList arrayList = null;
        if (this.events.size() > 0) {
            Object object = this.eventsLock;
            synchronized (object) {
                if (this.events.size() > 0) {
                    arrayList = this.events;
                    this.events = new ArrayList();
                }
                this.eventsLock.notifyAll();
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    NEWTEventTask nEWTEventTask = (NEWTEventTask)arrayList.get(i);
                    NEWTEvent nEWTEvent = nEWTEventTask.get();
                    Object object2 = nEWTEvent.getSource();
                    if (object2 instanceof NEWTEventConsumer) {
                        NEWTEventConsumer nEWTEventConsumer = (NEWTEventConsumer)object2;
                        if (!nEWTEventConsumer.consumeEvent(nEWTEvent)) {
                            this.enqueueEvent(false, nEWTEvent);
                        }
                    } else {
                        throw new RuntimeException("Event source not NEWT: " + object2.getClass().getName() + ", " + object2);
                    }
                    nEWTEventTask.notifyIssuer();
                }
            }
        }
        this.dispatchMessagesNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (!this.isEDTRunning()) {
            if (DEBUG) {
                Throwable throwable = new Throwable("Warning: EDT already stopped: wait:=" + bl + ", " + nEWTEvent);
                throwable.printStackTrace();
            }
            return;
        }
        Object object = new Object();
        NEWTEventTask nEWTEventTask = new NEWTEventTask(nEWTEvent, bl ? object : null);
        Object object2 = object;
        synchronized (object2) {
            Object object3 = this.eventsLock;
            synchronized (object3) {
                this.events.add(nEWTEventTask);
                this.eventsLock.notifyAll();
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        }
    }

    class DispatchMessagesRunnable
    implements Runnable {
        DispatchMessagesRunnable() {
        }

        @Override
        public void run() {
            DisplayImpl.this.dispatchMessages();
        }
    }
}

