/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.IpoHelper;
import com.jme3.scene.plugins.blender.structures.AbstractInfluenceFunction;
import com.jme3.scene.plugins.blender.structures.Constraint;
import com.jme3.scene.plugins.blender.structures.ConstraintType;
import com.jme3.scene.plugins.blender.structures.Ipo;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.Pointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstraintHelper
extends AbstractBlenderHelper {
    protected static AbstractInfluenceFunction[] influenceFunctions;
    protected Map<Long, Constraint[]> constraints = new HashMap<Long, Constraint[]>();

    public ConstraintHelper(String blenderVersion, DataRepository dataRepository) {
        super(blenderVersion);
        if (influenceFunctions == null) {
            influenceFunctions = new AbstractInfluenceFunction[ConstraintType.getLastDefinedTypeValue() + 1];
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_ACTION.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_ACTION, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_CHILDOF.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_CHILDOF, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_CLAMPTO.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_CLAMPTO, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    this.validateConstraintType(constraint.getData());
                    LOGGER.info(constraint.getName() + " not active! Curves not yet implemented!");
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_DISTLIMIT.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_DISTLIMIT, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintStructure = constraint.getData();
                    this.validateConstraintType(constraintStructure);
                    Vector3f targetLocation = this.getTargetLocation(constraint);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        float dist = ((Number)constraintStructure.getFieldValue("dist")).floatValue();
                        int mode = ((Number)constraintStructure.getFieldValue("mode")).intValue();
                        int maxFrames = boneTrack.getTimes().length;
                        Vector3f[] translations = boneTrack.getTranslations();
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            Vector3f v = translations[frame].subtract(targetLocation);
                            float currentDistance = v.length();
                            float influence = constraint.getIpo().calculateValue(frame);
                            float modifier = 0.0f;
                            switch (mode) {
                                case 0: {
                                    if (!(currentDistance >= dist)) break;
                                    modifier = (dist - currentDistance) / currentDistance;
                                    break;
                                }
                                case 2: {
                                    modifier = (dist - currentDistance) / currentDistance;
                                    break;
                                }
                                case 1: {
                                    if (!(currentDistance <= dist)) break;
                                    modifier = (dist - currentDistance) / currentDistance;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unknown distance limit constraint mode: " + mode);
                                }
                            }
                            translations[frame].addLocal(v.multLocal(modifier * influence));
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), translations, boneTrack.getRotations(), boneTrack.getScales());
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_FOLLOWPATH.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_FOLLOWPATH, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    this.validateConstraintType(constraint.getData());
                    LOGGER.info(constraint.getName() + " not active! Curves not yet implemented!");
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_KINEMATIC.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_KINEMATIC, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintStructure = constraint.getData();
                    this.validateConstraintType(constraintStructure);
                }

                private CalculationBone[] getBonesToCalculate(Bone bone, Skeleton skeleton, BoneAnimation boneAnimation) {
                    int i;
                    ArrayList<CalculationBone> bonesList = new ArrayList<CalculationBone>();
                    Bone currentBone = bone;
                    block0: do {
                        int boneIndex = skeleton.getBoneIndex(currentBone);
                        for (i = 0; i < boneAnimation.getTracks().length; ++i) {
                            if (boneAnimation.getTracks()[i].getTargetBoneIndex() != boneIndex) continue;
                            bonesList.add(new CalculationBone(currentBone, boneAnimation.getTracks()[i]));
                            continue block0;
                        }
                    } while ((currentBone = currentBone.getParent()) != null);
                    CalculationBone[] result = bonesList.toArray(new CalculationBone[bonesList.size()]);
                    for (i = result.length - 1; i > 0; --i) {
                        result[i].attachChild((Spatial)result[i - 1]);
                    }
                    return result;
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_LOCKTRACK.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_LOCKTRACK, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_LOCLIKE.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_LOCLIKE, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintData = constraint.getData();
                    this.validateConstraintType(constraintData);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        Vector3f targetLocation = this.getTargetLocation(constraint);
                        int flag = ((Number)constraintData.getFieldValue("flag")).intValue();
                        Vector3f[] translations = boneTrack.getTranslations();
                        int maxFrames = translations.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            Vector3f offset = Vector3f.ZERO;
                            if ((flag & 0x80) != 0) {
                                offset = translations[frame].clone();
                            }
                            if ((flag & 1) != 0) {
                                translations[frame].x = targetLocation.x;
                                if ((flag & 0x10) != 0) {
                                    translations[frame].x = -translations[frame].x;
                                }
                            } else if ((flag & 2) != 0) {
                                translations[frame].y = targetLocation.y;
                                if ((flag & 0x20) != 0) {
                                    translations[frame].y = -translations[frame].y;
                                }
                            } else if ((flag & 4) != 0) {
                                translations[frame].z = targetLocation.z;
                                if ((flag & 0x40) != 0) {
                                    translations[frame].z = -translations[frame].z;
                                }
                            }
                            translations[frame].addLocal(offset);
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), translations, boneTrack.getRotations(), boneTrack.getScales());
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_LOCLIMIT.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_LOCLIMIT, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintStructure = constraint.getData();
                    this.validateConstraintType(constraintStructure);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        int flag = ((Number)constraintStructure.getFieldValue("flag")).intValue();
                        Vector3f[] translations = boneTrack.getTranslations();
                        int maxFrames = translations.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            float zmax;
                            float zmin;
                            float ymax;
                            float ymin;
                            float xmax;
                            float xmin;
                            float influence = constraint.getIpo().calculateValue(frame);
                            if ((flag & 1) != 0 && translations[frame].x < (xmin = ((Number)constraintStructure.getFieldValue("xmin")).floatValue())) {
                                translations[frame].x -= (translations[frame].x - xmin) * influence;
                            }
                            if ((flag & 2) != 0 && translations[frame].x > (xmax = ((Number)constraintStructure.getFieldValue("xmax")).floatValue())) {
                                translations[frame].x -= (translations[frame].x - xmax) * influence;
                            }
                            if ((flag & 4) != 0 && translations[frame].y < (ymin = ((Number)constraintStructure.getFieldValue("ymin")).floatValue())) {
                                translations[frame].y -= (translations[frame].y - ymin) * influence;
                            }
                            if ((flag & 8) != 0 && translations[frame].y > (ymax = ((Number)constraintStructure.getFieldValue("ymax")).floatValue())) {
                                translations[frame].y -= (translations[frame].y - ymax) * influence;
                            }
                            if ((flag & 0x10) != 0 && translations[frame].z < (zmin = ((Number)constraintStructure.getFieldValue("zmin")).floatValue())) {
                                translations[frame].z -= (translations[frame].z - zmin) * influence;
                            }
                            if ((flag & 0x20) == 0 || !(translations[frame].z > (zmax = ((Number)constraintStructure.getFieldValue("zmax")).floatValue()))) continue;
                            translations[frame].z -= (translations[frame].z - zmax) * influence;
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), translations, boneTrack.getRotations(), boneTrack.getScales());
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_MINMAX.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_MINMAX, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_NULL.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_NULL, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_PYTHON.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_PYTHON, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_RIGIDBODYJOINT.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_RIGIDBODYJOINT, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_ROTLIKE.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_ROTLIKE, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintData = constraint.getData();
                    this.validateConstraintType(constraintData);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        Quaternion targetRotation = this.getTargetRotation(constraint);
                        int flag = ((Number)constraintData.getFieldValue("flag")).intValue();
                        float[] targetAngles = targetRotation.toAngles(null);
                        Quaternion[] rotations = boneTrack.getRotations();
                        int maxFrames = rotations.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            float[] angles = rotations[frame].toAngles(null);
                            Quaternion offset = Quaternion.IDENTITY;
                            if ((flag & 0x80) != 0) {
                                offset = rotations[frame].clone();
                            }
                            if ((flag & 1) != 0) {
                                angles[0] = targetAngles[0];
                                if ((flag & 0x10) != 0) {
                                    angles[0] = -angles[0];
                                }
                            } else if ((flag & 2) != 0) {
                                angles[1] = targetAngles[1];
                                if ((flag & 0x20) != 0) {
                                    angles[1] = -angles[1];
                                }
                            } else if ((flag & 4) != 0) {
                                angles[2] = targetAngles[2];
                                if ((flag & 0x40) != 0) {
                                    angles[2] = -angles[2];
                                }
                            }
                            rotations[frame].fromAngles(angles).multLocal(offset);
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), boneTrack.getTranslations(), rotations, boneTrack.getScales());
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_ROTLIMIT.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_ROTLIMIT, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintStructure = constraint.getData();
                    this.validateConstraintType(constraintStructure);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        int flag = ((Number)constraintStructure.getFieldValue("flag")).intValue();
                        Quaternion[] rotations = boneTrack.getRotations();
                        int maxFrames = rotations.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            float difference;
                            float[] angles = rotations[frame].toAngles(null);
                            float influence = constraint.getIpo().calculateValue(frame);
                            if ((flag & 1) != 0) {
                                float xmin = ((Number)constraintStructure.getFieldValue("xmin")).floatValue() * ((float)Math.PI / 180);
                                float xmax = ((Number)constraintStructure.getFieldValue("xmax")).floatValue() * ((float)Math.PI / 180);
                                difference = 0.0f;
                                if (angles[0] < xmin) {
                                    difference = (angles[0] - xmin) * influence;
                                } else if (angles[0] > xmax) {
                                    difference = (angles[0] - xmax) * influence;
                                }
                                angles[0] = angles[0] - difference;
                            }
                            if ((flag & 2) != 0) {
                                float ymin = ((Number)constraintStructure.getFieldValue("ymin")).floatValue() * ((float)Math.PI / 180);
                                float ymax = ((Number)constraintStructure.getFieldValue("ymax")).floatValue() * ((float)Math.PI / 180);
                                difference = 0.0f;
                                if (angles[1] < ymin) {
                                    difference = (angles[1] - ymin) * influence;
                                } else if (angles[1] > ymax) {
                                    difference = (angles[1] - ymax) * influence;
                                }
                                angles[1] = angles[1] - difference;
                            }
                            if ((flag & 4) != 0) {
                                float zmin = ((Number)constraintStructure.getFieldValue("zmin")).floatValue() * ((float)Math.PI / 180);
                                float zmax = ((Number)constraintStructure.getFieldValue("zmax")).floatValue() * ((float)Math.PI / 180);
                                difference = 0.0f;
                                if (angles[2] < zmin) {
                                    difference = (angles[2] - zmin) * influence;
                                } else if (angles[2] > zmax) {
                                    difference = (angles[2] - zmax) * influence;
                                }
                                angles[2] = angles[2] - difference;
                            }
                            rotations[frame].fromAngles(angles);
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), boneTrack.getTranslations(), rotations, boneTrack.getScales());
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_SHRINKWRAP.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_SHRINKWRAP, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_SIZELIKE.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_SIZELIKE, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintData = constraint.getData();
                    this.validateConstraintType(constraintData);
                    Vector3f targetScale = this.getTargetLocation(constraint);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        int flag = ((Number)constraintData.getFieldValue("flag")).intValue();
                        Vector3f[] scales = boneTrack.getScales();
                        int maxFrames = scales.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            Vector3f offset = Vector3f.ZERO;
                            if ((flag & 0x80) != 0) {
                                offset = scales[frame].clone();
                            }
                            if ((flag & 1) != 0) {
                                scales[frame].x = targetScale.x;
                            } else if ((flag & 2) != 0) {
                                scales[frame].y = targetScale.y;
                            } else if ((flag & 4) != 0) {
                                scales[frame].z = targetScale.z;
                            }
                            scales[frame].addLocal(offset);
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), boneTrack.getTranslations(), boneTrack.getRotations(), scales);
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_SIZELIMIT.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_SIZELIMIT, dataRepository){

                public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
                    Structure constraintStructure = constraint.getData();
                    this.validateConstraintType(constraintStructure);
                    BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation, constraint);
                    if (boneTrack != null) {
                        int flag = ((Number)constraintStructure.getFieldValue("flag")).intValue();
                        Vector3f[] scales = boneTrack.getScales();
                        int maxFrames = scales.length;
                        for (int frame = 0; frame < maxFrames; ++frame) {
                            float zmax;
                            float zmin;
                            float ymax;
                            float ymin;
                            float xmax;
                            float xmin;
                            float influence = constraint.getIpo().calculateValue(frame);
                            if ((flag & 1) != 0 && scales[frame].x < (xmin = ((Number)constraintStructure.getFieldValue("xmin")).floatValue())) {
                                scales[frame].x -= (scales[frame].x - xmin) * influence;
                            }
                            if ((flag & 2) != 0 && scales[frame].x > (xmax = ((Number)constraintStructure.getFieldValue("xmax")).floatValue())) {
                                scales[frame].x -= (scales[frame].x - xmax) * influence;
                            }
                            if ((flag & 4) != 0 && scales[frame].y < (ymin = ((Number)constraintStructure.getFieldValue("ymin")).floatValue())) {
                                scales[frame].y -= (scales[frame].y - ymin) * influence;
                            }
                            if ((flag & 8) != 0 && scales[frame].y > (ymax = ((Number)constraintStructure.getFieldValue("ymax")).floatValue())) {
                                scales[frame].y -= (scales[frame].y - ymax) * influence;
                            }
                            if ((flag & 0x10) != 0 && scales[frame].z < (zmin = ((Number)constraintStructure.getFieldValue("zmin")).floatValue())) {
                                scales[frame].z -= (scales[frame].z - zmin) * influence;
                            }
                            if ((flag & 0x20) == 0 || !(scales[frame].z > (zmax = ((Number)constraintStructure.getFieldValue("zmax")).floatValue()))) continue;
                            scales[frame].z -= (scales[frame].z - zmax) * influence;
                        }
                        boneTrack.setKeyframes(boneTrack.getTimes(), boneTrack.getTranslations(), boneTrack.getRotations(), scales);
                    }
                }
            };
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_STRETCHTO.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_STRETCHTO, dataRepository){};
            ConstraintHelper.influenceFunctions[ConstraintType.CONSTRAINT_TYPE_TRANSFORM.getConstraintId()] = new AbstractInfluenceFunction(ConstraintType.CONSTRAINT_TYPE_TRANSFORM, dataRepository){};
        }
    }

    public void loadConstraints(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        IpoHelper ipoHelper = (IpoHelper)dataRepository.getHelper(IpoHelper.class);
        HashMap constraintsIpos = new HashMap();
        Pointer pActions = (Pointer)objectStructure.getFieldValue("action");
        if (!pActions.isNull()) {
            List<Structure> actions = pActions.fetchData(dataRepository.getInputStream());
            for (Structure action : actions) {
                Structure chanbase = (Structure)action.getFieldValue("chanbase");
                List<Structure> actionChannels = chanbase.evaluateListBase(dataRepository);
                for (Structure actionChannel : actionChannels) {
                    HashMap<String, Ipo> ipos = new HashMap<String, Ipo>();
                    Structure constChannels = (Structure)actionChannel.getFieldValue("constraintChannels");
                    List<Structure> constraintChannels = constChannels.evaluateListBase(dataRepository);
                    for (Structure constraintChannel : constraintChannels) {
                        Pointer pIpo = (Pointer)constraintChannel.getFieldValue("ipo");
                        if (pIpo.isNull()) continue;
                        String constraintName = constraintChannel.getFieldValue("name").toString();
                        Ipo ipo = ipoHelper.createIpo(pIpo.fetchData(dataRepository.getInputStream()).get(0), dataRepository);
                        ipos.put(constraintName, ipo);
                    }
                    String actionName = actionChannel.getFieldValue("name").toString();
                    constraintsIpos.put(actionName, ipos);
                }
            }
        }
        ArrayList<Constraint> constraintsList = new ArrayList<Constraint>();
        Pointer pPose = (Pointer)objectStructure.getFieldValue("pose");
        if (!pPose.isNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData(dataRepository.getInputStream()).get(0).getFieldValue("chanbase")).evaluateListBase(dataRepository);
            for (Structure poseChannel : poseChannels) {
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                String name = dataRepository.getFileBlock(boneOMA).getStructure(dataRepository).getFieldValue("name").toString();
                List<Structure> constraints = ((Structure)poseChannel.getFieldValue("constraints")).evaluateListBase(dataRepository);
                for (Structure constraint : constraints) {
                    int type = ((Number)constraint.getFieldValue("type")).intValue();
                    String constraintName = constraint.getFieldValue("name").toString();
                    Ipo ipo = (Ipo)((Map)constraintsIpos.get(name)).get(constraintName);
                    if (ipo == null) {
                        float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                        ipo = ipoHelper.createIpo(enforce);
                    }
                    Constraint.Space ownerSpace = Constraint.Space.valueOf(((Number)constraint.getFieldValue("ownspace")).byteValue());
                    Constraint.Space targetSpace = Constraint.Space.valueOf(((Number)constraint.getFieldValue("tarspace")).byteValue());
                    Constraint c = new Constraint(constraint, influenceFunctions[type], boneOMA, ownerSpace, targetSpace, ipo, dataRepository);
                    constraintsList.add(c);
                }
            }
        }
        if (constraintsList.size() > 0) {
            this.constraints.put(objectStructure.getOldMemoryAddress(), constraintsList.toArray(new Constraint[constraintsList.size()]));
        }
    }

    public Constraint[] getConstraints(Long ownerOMA) {
        return this.constraints.get(ownerOMA);
    }

    public void clearState() {
        this.constraints.clear();
    }

    private static class CalculationBone
    extends Node {
        private String boneName;
        private BoneTrack track;
        private Vector3f startTranslation;
        private Quaternion startRotation;
        private Vector3f startScale;
        private Vector3f[] translations;
        private Quaternion[] rotations;
        private Vector3f[] scales;

        public CalculationBone(Bone bone, BoneTrack track) {
            this.boneName = bone.getName();
            this.track = track;
            this.startRotation = bone.getModelSpaceRotation().clone();
            this.startTranslation = bone.getModelSpacePosition().clone();
            this.startScale = bone.getModelSpaceScale().clone();
            this.translations = track.getTranslations();
            this.rotations = track.getRotations();
            this.scales = track.getScales();
            this.reset();
        }

        public Vector3f getEndPoint() {
            if (this.getParent() == null) {
                return new Vector3f(0.0f, this.getLocalScale().y, 0.0f);
            }
            Node parent = this.getParent();
            return parent.getWorldTranslation().subtract(this.getWorldTranslation()).multLocal(this.getWorldScale());
        }

        public void reset() {
            this.setLocalTranslation(this.startTranslation);
            this.setLocalRotation(this.startRotation);
            this.setLocalScale(this.startScale);
        }

        public int attachChild(Spatial child) {
            if (this.getChildren() != null && this.getChildren().size() > 1) {
                throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " class instance can only have one child!");
            }
            return super.attachChild(child);
        }

        public Spatial rotate(Quaternion rot, int frame) {
            Spatial spatial = super.rotate(rot);
            this.updateWorldTransforms();
            if (this.getChildren() != null && this.getChildren().size() > 0) {
                CalculationBone child = (CalculationBone)this.getChild(0);
                child.updateWorldTransforms();
            }
            this.rotations[frame].set(this.getLocalRotation());
            this.translations[frame].set(this.getLocalTranslation());
            if (this.scales != null) {
                this.scales[frame].set(this.getLocalScale());
            }
            return spatial;
        }

        public void applyCalculatedTracks() {
            this.track.setKeyframes(this.track.getTimes(), this.translations, this.rotations);
        }

        public String toString() {
            return this.boneName + ": " + this.getLocalRotation() + " " + this.getLocalTranslation();
        }
    }
}

