/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.structures;

import com.jme3.animation.BoneTrack;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.structures.BezierCurve;

public class Ipo {
    public static final int AC_LOC_X = 1;
    public static final int AC_LOC_Y = 2;
    public static final int AC_LOC_Z = 3;
    public static final int OB_ROT_X = 7;
    public static final int OB_ROT_Y = 8;
    public static final int OB_ROT_Z = 9;
    public static final int AC_SIZE_X = 13;
    public static final int AC_SIZE_Y = 14;
    public static final int AC_SIZE_Z = 15;
    public static final int AC_QUAT_W = 25;
    public static final int AC_QUAT_X = 26;
    public static final int AC_QUAT_Y = 27;
    public static final int AC_QUAT_Z = 28;
    private BezierCurve[] bezierCurves;
    private BoneTrack calculatedTrack;

    public Ipo(BezierCurve[] bezierCurves) {
        this.bezierCurves = bezierCurves;
    }

    public float calculateValue(int frame) {
        return this.calculateValue(frame, 0);
    }

    public float calculateValue(int frame, int curveIndex) {
        return this.bezierCurves[curveIndex].evaluate(frame, 1);
    }

    public int getCurvesAmount() {
        return this.bezierCurves.length;
    }

    public int getLastFrame() {
        int result = 1;
        for (int i = 0; i < this.bezierCurves.length; ++i) {
            int tempResult = this.bezierCurves[i].getLastFrame();
            if (tempResult <= result) continue;
            result = tempResult;
        }
        return result;
    }

    public void modifyTranslation(int frame, Vector3f translation) {
        if (this.calculatedTrack != null) {
            this.calculatedTrack.getTranslations()[frame].set(translation);
        }
    }

    public void modifyRotation(int frame, Quaternion rotation) {
        if (this.calculatedTrack != null) {
            this.calculatedTrack.getRotations()[frame].set(rotation);
        }
    }

    public void modifyScale(int frame, Vector3f scale) {
        if (this.calculatedTrack != null) {
            this.calculatedTrack.getScales()[frame].set(scale);
        }
    }

    public BoneTrack calculateTrack(int boneIndex, int startFrame, int stopFrame, int fps) {
        int framesAmount = stopFrame - startFrame;
        float start = ((float)startFrame - 1.0f) / (float)fps;
        float timeBetweenFrames = 1.0f / (float)fps;
        float[] times = new float[framesAmount + 1];
        Vector3f[] translations = new Vector3f[framesAmount + 1];
        float[] translation = new float[3];
        Quaternion[] rotations = new Quaternion[framesAmount + 1];
        float[] quaternionRotation = new float[4];
        float[] objectRotation = new float[3];
        boolean bObjectRotation = false;
        Vector3f[] scales = new Vector3f[framesAmount + 1];
        float[] scale = new float[3];
        for (int frame = startFrame; frame <= stopFrame; ++frame) {
            int index = frame - startFrame;
            times[index] = start + (float)(frame - 1) * timeBetweenFrames;
            translations[index] = new Vector3f();
            block8: for (int j = 0; j < this.bezierCurves.length; ++j) {
                double value = this.bezierCurves[j].evaluate(frame, 1);
                switch (this.bezierCurves[j].getType()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        translation[this.bezierCurves[j].getType() - 1] = (float)value;
                        continue block8;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectRotation[this.bezierCurves[j].getType() - 7] = (float)value;
                        bObjectRotation = true;
                        continue block8;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        scale[this.bezierCurves[j].getType() - 13] = (float)value;
                        continue block8;
                    }
                    case 25: {
                        quaternionRotation[3] = (float)value;
                        continue block8;
                    }
                    case 26: 
                    case 27: 
                    case 28: {
                        quaternionRotation[this.bezierCurves[j].getType() - 26] = (float)value;
                        continue block8;
                    }
                }
            }
            translations[index] = new Vector3f(translation[0], translation[1], translation[2]);
            rotations[index] = bObjectRotation ? new Quaternion().fromAngles(objectRotation) : new Quaternion(quaternionRotation[0], quaternionRotation[1], quaternionRotation[2], quaternionRotation[3]);
            scales[index] = new Vector3f(scale[0], scale[1], scale[2]);
        }
        this.calculatedTrack = new BoneTrack(boneIndex, times, translations, rotations, scales);
        return this.calculatedTrack;
    }
}

