/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.utils;

import com.jme3.scene.plugins.blender.data.FileBlockHeader;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.utils.BlenderInputStream;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pointer {
    private DataRepository dataRepository;
    private int pointerLevel;
    private long oldMemoryAddress;
    public boolean function;

    public Pointer(int pointerLevel, boolean function, DataRepository dataRepository) {
        this.pointerLevel = pointerLevel;
        this.function = function;
        this.dataRepository = dataRepository;
    }

    public void fill(BlenderInputStream inputStream) {
        this.oldMemoryAddress = inputStream.readPointer();
    }

    public List<Structure> fetchData(BlenderInputStream inputStream) throws BlenderFileException {
        if (this.oldMemoryAddress == 0L) {
            throw new NullPointerException("The pointer points to nothing!");
        }
        List<Structure> structures = null;
        FileBlockHeader dataFileBlock = this.dataRepository.getFileBlock(this.oldMemoryAddress);
        if (this.pointerLevel > 1) {
            int pointersAmount = dataFileBlock.getSize() / inputStream.getPointerSize() * dataFileBlock.getCount();
            for (int i = 0; i < pointersAmount; ++i) {
                inputStream.setPosition(dataFileBlock.getBlockPosition() + inputStream.getPointerSize() * i);
                long oldMemoryAddress = inputStream.readPointer();
                if (oldMemoryAddress == 0L) continue;
                Pointer p = new Pointer(this.pointerLevel - 1, this.function, this.dataRepository);
                p.oldMemoryAddress = oldMemoryAddress;
                if (structures == null) {
                    structures = p.fetchData(inputStream);
                    continue;
                }
                structures.addAll(p.fetchData(inputStream));
            }
        } else {
            inputStream.setPosition(dataFileBlock.getBlockPosition());
            structures = new ArrayList<Structure>(dataFileBlock.getCount());
            for (int i = 0; i < dataFileBlock.getCount(); ++i) {
                Structure structure = this.dataRepository.getDnaBlockData().getStructure(dataFileBlock.getSdnaIndex());
                structure.fill(inputStream);
                structures.add(structure);
            }
            return structures;
        }
        return structures;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isNull() {
        return this.oldMemoryAddress == 0L;
    }

    public long getOldMemoryAddress() {
        return this.oldMemoryAddress;
    }

    public String toString() {
        return this.oldMemoryAddress == 0L ? "{$null$}" : "{$" + this.oldMemoryAddress + "$}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.oldMemoryAddress ^ this.oldMemoryAddress >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.oldMemoryAddress == other.oldMemoryAddress;
    }
}

