/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.NiftyDefaults;
import de.lessvoid.nifty.NiftyEventSubscriber;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class NiftyEventAnnotationProcessor {
    private static Logger log = Logger.getLogger(NiftyEventAnnotationProcessor.class.getName());

    public static void process(Object obj) {
        NiftyEventAnnotationProcessor.processOrUnprocess(obj, true);
    }

    public static void unprocess(Object obj) {
        NiftyEventAnnotationProcessor.processOrUnprocess(obj, false);
    }

    private static void processOrUnprocess(Object obj, boolean add) {
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        Object[] methods = cl.getMethods();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for EventBus annotations for class " + cl + ", methods:" + Arrays.toString(methods));
        }
        for (Object method : methods) {
            NiftyEventSubscriber niftyEventSubscriber = ((Method)method).getAnnotation(NiftyEventSubscriber.class);
            if (niftyEventSubscriber == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found NiftyEventSubscriber:" + niftyEventSubscriber + " on method:" + method);
            }
            NiftyEventAnnotationProcessor.process(niftyEventSubscriber, obj, (Method)method, add);
        }
    }

    private static void process(NiftyEventSubscriber annotation, Object obj, Method method, boolean add) {
        String id = annotation.id();
        String pattern = annotation.pattern();
        NiftyEventAnnotationProcessor.ensureNotNull(id, pattern);
        NiftyEventAnnotationProcessor.ensureMethodParamCount(method.getParameterTypes());
        EventService eventService = NiftyEventAnnotationProcessor.getEventService();
        Class<?> eventClass = method.getParameterTypes()[1];
        if (NiftyEventAnnotationProcessor.isSet(id)) {
            NiftyEventAnnotationProcessor.idProcess(obj, method, add, id, eventClass, eventService);
        } else {
            NiftyEventAnnotationProcessor.patternProcess(obj, method, add, pattern, eventClass, eventService);
        }
    }

    private static boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    private static void ensureNotNull(String id, String pattern) {
        if (!NiftyEventAnnotationProcessor.isSet(id) && !NiftyEventAnnotationProcessor.isSet(pattern)) {
            throw new IllegalArgumentException("id or pattern must have a value for NiftyEventSubscriber annotation");
        }
    }

    private static void ensureMethodParamCount(Class<?>[] params) {
        if (params == null || params.length != 2 || !String.class.equals(params[0]) || params[1].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
    }

    private static void patternProcess(Object obj, Method method, boolean add, String topicPattern, Class<?> eventClass, EventService eventService) {
        Pattern pattern = Pattern.compile(topicPattern);
        if (add) {
            Subscriber subscriber = new Subscriber(obj, method, eventClass);
            eventService.subscribeStrongly(pattern, (EventTopicSubscriber)subscriber);
            NiftyDefaults.eventBusLog.info("-> subscribe [" + pattern + "] -> [" + subscriber + "]");
        } else {
            eventService.unsubscribe(pattern, obj);
            NiftyDefaults.eventBusLog.info("<- unsubscribe [" + pattern + "] -> [" + obj + "]");
        }
    }

    private static void idProcess(Object obj, Method method, boolean add, String id, Class<?> eventClass, EventService eventService) {
        if (add) {
            Subscriber subscriber = new Subscriber(obj, method, eventClass);
            eventService.subscribeStrongly(id, (EventTopicSubscriber)subscriber);
            NiftyDefaults.eventBusLog.info("-> subscribe [" + id + "] -> [" + subscriber + "]");
        } else {
            eventService.unsubscribe(id, obj);
            NiftyDefaults.eventBusLog.info("<- unsubscribe [" + id + "] -> [" + obj + "]");
        }
    }

    private static EventService getEventService() {
        return EventServiceLocator.getEventService((String)"NiftyEventBus");
    }

    private static class Subscriber
    implements EventTopicSubscriber<Object>,
    ProxySubscriber {
        private final Object obj;
        private final Method method;
        private final Class<?> eventClass;

        private Subscriber(Object obj, Method method, Class<?> eventClass) {
            this.obj = obj;
            this.method = method;
            this.eventClass = eventClass;
        }

        public void onEvent(String topic, Object data) {
            if (this.eventClass.isInstance(data)) {
                try {
                    this.method.invoke(this.obj, topic, this.eventClass.cast(data));
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "failed to invoke method [" + this.method + "] with Exception [" + e.getMessage() + "][" + e.getCause() + "]", e);
                }
            }
        }

        public Object getProxiedSubscriber() {
            return this.obj;
        }

        public void proxyUnsubscribed() {
        }

        public ReferenceStrength getReferenceStrength() {
            return ReferenceStrength.STRONG;
        }
    }
}

