/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class FocusHandler {
    private Logger log = Logger.getLogger(FocusHandler.class.getName());
    private ArrayList<Element> entries = new ArrayList();
    private ArrayList<ArrayList<Element>> elementBuffer = new ArrayList();
    private Element mouseFocusElement = null;
    private ArrayList<Element> mouseFocusElementBuffer = new ArrayList();
    private Element keyboardFocusElement = null;
    private ArrayList<Element> keyboardFocusElementBuffer = new ArrayList();

    public void addElement(Element element) {
        this.addElement(element, null);
    }

    public void addElement(Element element, Element focusableInsertBeforeElement) {
        if (focusableInsertBeforeElement == null) {
            this.entries.add(element);
        } else {
            int idx = this.entries.indexOf(focusableInsertBeforeElement);
            if (idx == -1) {
                this.log.warning("requesting to add focusable element before [" + focusableInsertBeforeElement + "] but I can't find it on the current screen. Adding it to the end of the list (like in the regular case)");
                this.entries.add(element);
            } else {
                this.entries.add(idx, focusableInsertBeforeElement);
            }
        }
    }

    public Element getNext(Element current) {
        Element nextElement;
        if (this.entries.isEmpty()) {
            return current;
        }
        int index = this.entries.indexOf(this.keyboardFocusElement);
        if (index == -1) {
            return current;
        }
        do {
            if (++index >= this.entries.size()) {
                index = 0;
            }
            if ((nextElement = this.entries.get(index)) != current) continue;
            return current;
        } while (!nextElement.isFocusable());
        return nextElement;
    }

    public Element getPrev(Element current) {
        Element prevElement;
        if (this.entries.isEmpty()) {
            return current;
        }
        int index = this.entries.indexOf(this.keyboardFocusElement);
        if (index == -1) {
            return current;
        }
        do {
            if (--index < 0) {
                index = this.entries.size() - 1;
            }
            if ((prevElement = this.entries.get(index)) != current) continue;
            return current;
        } while (!prevElement.isFocusable());
        return prevElement;
    }

    public void remove(Element element) {
        this.entries.remove(element);
        this.lostKeyboardFocus(element);
        this.lostMouseFocus(element);
    }

    public Element getFirstFocusElement() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(0);
    }

    public void pushState() {
        ArrayList<Element> copy = new ArrayList<Element>();
        copy.addAll(this.entries);
        this.elementBuffer.add(copy);
        this.entries.clear();
        this.keyboardFocusElementBuffer.add(this.keyboardFocusElement);
        this.lostKeyboardFocus(this.keyboardFocusElement);
        this.mouseFocusElementBuffer.add(this.mouseFocusElement);
        this.lostMouseFocus(this.mouseFocusElement);
    }

    public void popState() {
        this.entries.clear();
        this.entries.addAll((Collection<Element>)this.elementBuffer.get(this.elementBuffer.size() - 1));
        this.setKeyFocus(this.keyboardFocusElementBuffer.remove(this.keyboardFocusElementBuffer.size() - 1));
        this.mouseFocusElement = this.mouseFocusElementBuffer.remove(this.mouseFocusElementBuffer.size() - 1);
        this.mouseFocusElement = null;
    }

    public void resetFocusElements() {
        this.lostKeyboardFocus(this.keyboardFocusElement);
        this.lostMouseFocus(this.mouseFocusElement);
    }

    public void setKeyFocus(Element newFocusElement) {
        if (this.keyboardFocusElement == newFocusElement) {
            return;
        }
        if (this.keyboardFocusElement != null) {
            this.keyboardFocusElement.stopEffect(EffectEventId.onFocus);
            this.keyboardFocusElement.startEffect(EffectEventId.onLostFocus);
        }
        boolean startOnGetFocus = false;
        if (this.keyboardFocusElement != newFocusElement) {
            startOnGetFocus = true;
        }
        this.keyboardFocusElement = newFocusElement;
        this.log.fine("keyboard focus element now changed to [" + (this.keyboardFocusElement == null ? "" : this.keyboardFocusElement.toString()) + "]");
        if (this.keyboardFocusElement != null) {
            this.keyboardFocusElement.startEffect(EffectEventId.onFocus);
            if (startOnGetFocus) {
                this.keyboardFocusElement.startEffect(EffectEventId.onGetFocus);
            }
        }
    }

    public void lostKeyboardFocus(Element elementThatLostFocus) {
        if (elementThatLostFocus != null) {
            this.log.fine("lostKeyboardFocus for [" + elementThatLostFocus.toString() + "]");
            if (this.keyboardFocusElement == elementThatLostFocus) {
                this.keyboardFocusElement.stopEffect(EffectEventId.onFocus);
                this.keyboardFocusElement.startEffect(EffectEventId.onLostFocus);
                this.keyboardFocusElement = null;
            }
        }
    }

    public boolean keyEvent(KeyboardInputEvent inputEvent) {
        if (this.keyboardFocusElement != null) {
            return this.keyboardFocusElement.keyEvent(inputEvent);
        }
        return false;
    }

    public void requestExclusiveMouseFocus(Element newFocusElement) {
        if (this.mouseFocusElement == newFocusElement) {
            return;
        }
        this.mouseFocusElement = newFocusElement;
        this.log.fine("requestExclusiveMouseFocus for [" + this.mouseFocusElement.toString() + "]");
    }

    public boolean hasExclusiveMouseFocus(Element element) {
        return element.equals(this.mouseFocusElement);
    }

    public boolean canProcessMouseEvents(Element element) {
        if (this.mouseFocusElement == null) {
            return true;
        }
        boolean canProcess = this.mouseFocusElement == element;
        this.log.fine("canProcessMouseEvents for [" + element.toString() + "] ==> " + canProcess + " (" + this.mouseFocusElement.toString() + ")");
        return canProcess;
    }

    public void lostMouseFocus(Element elementThatLostFocus) {
        if (elementThatLostFocus != null) {
            this.log.fine("lostMouseFocus for [" + elementThatLostFocus.toString() + "]");
            if (this.mouseFocusElement == elementThatLostFocus) {
                this.mouseFocusElement = null;
            }
        }
    }

    public String toString() {
        String mouseFocusString = "---";
        if (this.mouseFocusElement != null) {
            mouseFocusString = this.mouseFocusElement.toString();
        }
        String keyboardFocusString = "---";
        if (this.keyboardFocusElement != null) {
            keyboardFocusString = this.keyboardFocusElement.toString();
        }
        StringBuffer focusElements = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            Element e = this.entries.get(i);
            if (i > 0) {
                focusElements.append(", ");
            }
            focusElements.append(e.getId() + (!e.isFocusable() ? "*" : ""));
        }
        return "\nfocus element (mouse):    " + mouseFocusString + "\n" + "focus element (keyboard): " + keyboardFocusString + "\n" + "focus element size: " + this.entries.size() + " [" + focusElements.toString() + "]";
    }

    public boolean hasAnyElementTheKeyboardFocus() {
        return this.keyboardFocusElement != null;
    }

    public Element findElement(String defaultFocusElementId) {
        for (Element element : this.entries) {
            if (!defaultFocusElementId.equals(element.getId())) continue;
            return element;
        }
        return null;
    }

    public Element getKeyboardFocusElement() {
        return this.keyboardFocusElement;
    }

    public Element getMouseFocusElement() {
        return this.mouseFocusElement;
    }
}

