/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image;

import de.lessvoid.nifty.ParameterizedObjectFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class ImageModeHelper {
    private static Logger log = Logger.getLogger(ParameterizedObjectFactory.class.getName());

    public String getAreaProviderProperty(Properties properties) {
        return this.getAreaProviderProperty(new StringPropertyAdapter(properties));
    }

    public String getAreaProviderProperty(Map<String, String> properties) {
        String imageModeProperty = properties.get("imageMode");
        String property = this.getAreaProviderProperty(imageModeProperty);
        if (property != null) {
            log.info("imageMode property converted to imageArea property : " + imageModeProperty + " -> " + property);
            return property;
        }
        return properties.get("imageArea");
    }

    public String getAreaProviderProperty(String imageModeProperty) {
        if (imageModeProperty != null) {
            String[] imageMode = imageModeProperty.split(":");
            String imageModeName = imageMode[0];
            if (imageModeName.equals("normal") || imageModeName.equals("resize")) {
                return "fullimage";
            }
            if (imageModeName.equals("subImage") || imageModeName.equals("repeat")) {
                return "subimage:" + this.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite")) {
                return "sprite:" + this.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite-resize")) {
                String imageModeParameters = imageMode[1];
                return "sprite:" + imageModeParameters.replace("," + this.getNinePartParameters(imageModeParameters), "");
            }
            log.warning("imageMode property could not be converted to imageArea property : " + imageModeProperty);
        }
        return null;
    }

    public String getRenderStrategyProperty(Properties properties) {
        return this.getRenderStrategyProperty(new StringPropertyAdapter(properties));
    }

    public String getRenderStrategyProperty(Map<String, String> properties) {
        String imageModeProperty = properties.get("imageMode");
        String property = this.getRenderStrategyProperty(imageModeProperty);
        if (property != null) {
            log.info("imageMode property converted to renderStrategy property : " + imageModeProperty + " -> " + property);
            return property;
        }
        return properties.get("renderStrategy");
    }

    public String getRenderStrategyProperty(String imageModeProperty) {
        if (imageModeProperty != null) {
            String[] imageMode = imageModeProperty.split(":");
            String imageModeName = imageMode[0];
            if (imageModeName.equals("normal") || imageModeName.equals("subImage") || imageModeName.equals("sprite")) {
                return "resize";
            }
            if (imageModeName.equals("resize")) {
                return "nine-part:" + this.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite-resize")) {
                return "nine-part:" + this.getNinePartParameters(this.getImageModeParameters(imageMode));
            }
            if (imageModeName.equals("repeat")) {
                return "repeat";
            }
            log.warning("imageMode property could not be converted to renderStrategy property : " + imageModeProperty);
        }
        return null;
    }

    private String getImageModeParameters(String[] imageMode) {
        if (imageMode.length > 1) {
            return imageMode[1];
        }
        return "";
    }

    private String getNinePartParameters(String imageMode) {
        String[] split = imageMode.split("(\\d+,){3}", 2);
        if (split.length > 1) {
            return split[1];
        }
        return "";
    }

    private static class StringPropertyAdapter
    implements Map<String, String> {
        private final Properties m_properties;

        public StringPropertyAdapter(Properties properties) {
            this.m_properties = properties;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String get(Object key) {
            return this.m_properties.getProperty((String)key);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> values() {
            throw new UnsupportedOperationException();
        }
    }
}

